/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayCloseIndexSearcher
extends IndexSearcher {
    private IndexReader indexReader;
    private int usageCount;
    private boolean shouldCloseWhenDone;
    private static final Logger log = LoggerFactory.getLogger(DelayCloseIndexSearcher.class);

    public DelayCloseIndexSearcher(IndexReader indexReader) throws IOException {
        super(indexReader);
        this.indexReader = indexReader;
        this.usageCount = 0;
        this.shouldCloseWhenDone = false;
        log.debug("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            if (this.shouldCloseWhenDone) {
                throw new IllegalStateException("closeWhenDone() already called");
            }
            ++this.usageCount;
        }
        log.debug("open()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWhenDone() throws IOException {
        boolean doClose;
        log.debug("closeWhenDone()");
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            if (this.shouldCloseWhenDone) {
                throw new IllegalStateException("closeWhenDone() already called");
            }
            this.shouldCloseWhenDone = true;
            doClose = this.usageCount == 0;
        }
        if (doClose) {
            this.closeInternal();
        }
    }

    public boolean isCurrent() throws IOException {
        IndexReader r = this.getIndexReader();
        assert (r instanceof DirectoryReader) : "searcher's IndexReader should be a DirectoryReader, but got " + r;
        return ((DirectoryReader)r).isCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            return this.shouldCloseWhenDone && this.usageCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        boolean doClose;
        log.debug("close()");
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            if (this.usageCount <= 0) {
                throw new IllegalStateException("usageCount<=0");
            }
            doClose = --this.usageCount == 0 && this.shouldCloseWhenDone;
        }
        if (doClose) {
            this.closeInternal();
        }
    }

    private void closeInternal() throws IOException {
        log.debug("Closing underlying index searcher");
        log.debug("Closing underlying index reader");
        this.indexReader.close();
    }
}

