/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.SortedMap;

public class DelegatingCacheStatistics {
    public static SortedMap<CacheStatisticsKey, Supplier<Long>> toStatistics(Cache<?, ?> internalCache) {
        ImmutableSortedMap.Builder map = ImmutableSortedMap.orderedBy((Comparator)CacheStatisticsKey.SORT_BY_LABEL).put((Object)CacheStatisticsKey.SIZE, DelegatingCacheStatistics.memoize(internalCache.size())).put((Object)CacheStatisticsKey.HIT_COUNT, DelegatingCacheStatistics.memoize(internalCache.stats().hitCount())).put((Object)CacheStatisticsKey.MISS_COUNT, DelegatingCacheStatistics.memoize(internalCache.stats().missCount())).put((Object)CacheStatisticsKey.EVICTION_COUNT, DelegatingCacheStatistics.memoize(internalCache.stats().evictionCount()));
        if (internalCache instanceof LoadingCache) {
            map.put((Object)CacheStatisticsKey.TOTAL_MISS_TIME, DelegatingCacheStatistics.memoize(internalCache.stats().totalLoadTime()));
        }
        return map.build();
    }

    private static <V> Supplier<V> memoize(V value) {
        return new ImmediateSupplier<V>(value);
    }

    static class ImmediateSupplier<V>
    implements Supplier<V> {
        private final V value;

        ImmediateSupplier(V value) {
            this.value = value;
        }

        public V get() {
            return this.value;
        }

        public String toString() {
            return "ImmediateSupplier[" + this.value + ']';
        }
    }
}

