package com.atlassian.confluence.index.api;

/**
 * Field that supports efficient sorting and range queries for signed byte values. (-128 to 127)
 */
public class ByteFieldDescriptor extends FieldDescriptor
{
    private final byte byteValue;

    public ByteFieldDescriptor(String name,
                               byte value,
                               Store store)
    {
        super(name, String.valueOf(value), store, Index.ANALYZED);
        byteValue = value;
    }

    @Override
    public <T> T visit(FieldVisitor<T> fieldVisitor)
    {
        return fieldVisitor.visit(this);
    }

    public byte byteValue()
    {
        return byteValue;
    }
}
