package com.atlassian.confluence.index.api;

import java.util.Date;

/**
 * Field that supports storing date values.
 */
public class DateFieldDescriptor extends FieldDescriptor
{
    private final Date dateValue;

    public DateFieldDescriptor(String name,
                               Date value,
                               Store store)
    {
        super(name, String.valueOf(value), store, Index.ANALYZED);
        dateValue = value;
    }

    @Override
    public <T> T visit(FieldVisitor<T> fieldVisitor)
    {
        return fieldVisitor.visit(this);
    }

    public Date dateValue()
    {
        return dateValue;
    }
}
