package com.atlassian.confluence.index.api;

/**
 * Field that supports efficient sorting and range queries float values.
 */
public class FloatFieldDescriptor extends FieldDescriptor
{
    private final float floatValue;

    public FloatFieldDescriptor(String name,
                                float value,
                                Store store)
    {
        super(name, String.valueOf(value), store, Index.ANALYZED);
        floatValue = value;
    }

    @Override
    public <T> T visit(FieldVisitor<T> fieldVisitor)
    {
        return fieldVisitor.visit(this);
    }

    public float floatValue()
    {
        return floatValue;
    }
}
