package com.atlassian.confluence.index.api;

/**
 * Field that supports efficient sorting and range queries integer values.
 */
public class IntFieldDescriptor extends FieldDescriptor
{
    private final int intValue;

    public IntFieldDescriptor(String name,
                              int value,
                              Store store)
    {
        super(name, String.valueOf(value), store, Index.ANALYZED);
        intValue = value;
    }

    @Override
    public <T> T visit(FieldVisitor<T> fieldVisitor)
    {
        return fieldVisitor.visit(this);
    }

    public int intValue()
    {
        return intValue;
    }
}
