package com.atlassian.confluence.index.api;

/**
 * Field that supports efficient sorting and range queries long values.
 */
public class LongFieldDescriptor extends FieldDescriptor
{
    private final long longValue;

    public LongFieldDescriptor(String name,
                               long value,
                               Store store)
    {
        super(name, String.valueOf(value), store, Index.ANALYZED);
        longValue = value;
    }

    @Override
    public <T> T visit(FieldVisitor<T> fieldVisitor)
    {
        return fieldVisitor.visit(this);
    }

    public long longValue()
    {
        return longValue;
    }
}
