package com.atlassian.confluence.index.api;

/**
 * Field that supports efficient sorting and range queries for signed short values. (-32,768 to 32,767)
 */
public class ShortFieldDescriptor extends FieldDescriptor
{
    private final short shortValue;

    public ShortFieldDescriptor(String name,
                                short value,
                                Store store)
    {
        super(name, String.valueOf(value), store, Index.ANALYZED);
        shortValue = value;
    }

    @Override
    public <T> T visit(FieldVisitor<T> fieldVisitor)
    {
        return fieldVisitor.visit(this);
    }

    public short shortValue()
    {
        return shortValue;
    }
}
