/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.DaoDiscriminator;
import com.atlassian.crowd.dao.RefreshableDao;
import com.atlassian.crowd.dao.directory.DirectoryPropertiesMapper;
import com.atlassian.crowd.dao.util.DatabaseFileLocator;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryDAOFile
implements DirectoryDao,
DaoDiscriminator,
RefreshableDao {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryDAOFile.class);
    private Properties properties;
    private Date timestamp;
    private final DirectoryPropertiesMapper directoryPropertiesMapper;
    private final DatabaseFileLocator databaseFileLocator;

    public DirectoryDAOFile(DatabaseFileLocator databaseFileLocator, DirectoryPropertiesMapper directoryPropertiesMapper) {
        this.databaseFileLocator = databaseFileLocator;
        this.directoryPropertiesMapper = directoryPropertiesMapper;
        this.refresh();
    }

    public synchronized void refresh() {
        File file = this.databaseFileLocator.getFile();
        if (file.exists()) {
            if (this.timestamp == null || this.timestamp.getTime() < file.lastModified()) {
                this.timestamp = new Date(file.lastModified());
                this.properties = DirectoryDAOFile.readProperties(file);
            } else {
                logger.debug("Skipping refresh because the file modification date has not changed");
            }
        } else {
            if (this.properties != null) {
                logger.info("File {} is missing, no longer using it for directory configuration", (Object)file.getPath());
            }
            this.timestamp = null;
            this.properties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProperties(File file) {
        Properties properties;
        Properties properties2 = new Properties();
        FileReader reader = new FileReader(file);
        try {
            properties2.load(reader);
            logger.info("Directory configuration has been read from file {}", (Object)file.getCanonicalPath());
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                logger.error("While reading the DAO file override", (Throwable)e);
                return null;
            }
        }
        reader.close();
        return properties;
    }

    public Directory findById(long directoryId) throws DirectoryNotFoundException {
        return this.directoryPropertiesMapper.importDirectory(this.properties, directoryId, this.timestamp);
    }

    public Directory findByName(String name) throws DirectoryNotFoundException {
        for (Directory directory : this.findAll()) {
            if (!name.equals(directory.getName())) continue;
            return directory;
        }
        throw new DirectoryNotFoundException(name);
    }

    public List<Directory> findAll() {
        return this.directoryPropertiesMapper.importAllDirectories(this.properties, this.timestamp);
    }

    public Directory add(Directory directory) {
        throw new UnsupportedOperationException("The file-based directory configuration is read-only");
    }

    public Directory update(Directory directory) throws DirectoryNotFoundException {
        throw new UnsupportedOperationException("The file-based directory configuration is read-only");
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        throw new UnsupportedOperationException("The file-based directory configuration is read-only");
    }

    public List<Directory> search(EntityQuery<Directory> entityQuery) {
        if (entityQuery.getEntityDescriptor().equals((Object)EntityDescriptor.directory()) && entityQuery.getSearchRestriction() instanceof NullRestriction) {
            return SearchResultsUtil.constrainResults(this.findAll(), (int)entityQuery.getStartIndex(), (int)entityQuery.getMaxResults());
        }
        throw new UnsupportedOperationException("The file-based directory configuration does not support non-trivial search");
    }

    public synchronized boolean isActive() {
        return this.properties != null;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

