/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.DaoDiscriminator;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.util.List;

public class FailoverDirectoryDAO
implements DirectoryDao {
    private final DirectoryDao primaryDao;
    private final DirectoryDao secondaryDao;
    private final DaoDiscriminator daoDiscriminator;

    public FailoverDirectoryDAO(DirectoryDao primaryDao, DirectoryDao secondaryDao, DaoDiscriminator daoDiscriminator) {
        this.primaryDao = primaryDao;
        this.secondaryDao = secondaryDao;
        this.daoDiscriminator = daoDiscriminator;
    }

    public Directory findById(long directoryId) throws DirectoryNotFoundException {
        return this.getEffectiveDao().findById(directoryId);
    }

    public Directory findByName(String name) throws DirectoryNotFoundException {
        return this.getEffectiveDao().findByName(name);
    }

    public List<Directory> findAll() {
        return this.getEffectiveDao().findAll();
    }

    public Directory add(Directory directory) {
        return this.getEffectiveDao().add(directory);
    }

    public Directory update(Directory directory) throws DirectoryNotFoundException {
        return this.getEffectiveDao().update(directory);
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        this.getEffectiveDao().remove(directory);
    }

    public List<Directory> search(EntityQuery<Directory> entityQuery) {
        return this.getEffectiveDao().search(entityQuery);
    }

    private DirectoryDao getEffectiveDao() {
        if (this.daoDiscriminator.isActive()) {
            return this.primaryDao;
        }
        return this.secondaryDao;
    }
}

