package com.atlassian.dragonfly.api;

import java.net.URI;

/**
 * Encapsulates integration setup with a remote JIRA instance.
 *
 * This has been designed and tested with the Setup process in mind, and makes the assumption that both the local
 * server and the remote JIRA server have identical user bases and <strong>trust</strong>.
 */
public interface JiraIntegrationConfigurator
{
    /**
     * Integrates the application with a remote Jira instance.
     *
     * @param remoteJiraUrl url of the remote JIRA application
     * @param localUrl url of the local application, resolvable by the remote JIRA.
     * @param username JIRA administrator username
     * @param password password corresponding to the supplied username
     *
     * @throws JiraIntegrationConfigurationException if anything went wrong, also in which case all the applied configurations will be rolled back.
     */
    void integrateWithJira(URI remoteJiraUrl, URI localUrl, String username, String password) throws JiraIntegrationConfigurationException;
}