package com.atlassian.dragonfly.spi;

import com.atlassian.crowd.model.application.ApplicationType;

import java.net.URI;

/**
 * Functionality required by the application in order to automate the JIRA integration process.
 */
public interface JiraIntegrationSetupHelper
{
    /**
     * Get type of the application.
     *
     * @return application type.
     */
    ApplicationType getApplicationType();

    /**
     * Switches the application's authentication mechanism to use crowd's.
     *
     * @param remoteJiraUrl url of the remote JIRA instance
     * @param applicationName application name as already been setup in crowd
     * @param applicationPassword application password
     */
    void switchToCrowdAuthentication(URI remoteJiraUrl, String applicationName, String applicationPassword);

    /**
     * Switches the application's authentication mechanism to the application's default.
     */
    void switchToDefaultAuthentication();
}
