/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ozymandias;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafeAccess;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.ThrowableLogger;
import com.atlassian.ozymandias.error.IncorrectModuleTypeError;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleExceptionError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafePluginPointAccess
implements SafeAccessViaPluginAccessor,
SafeAccess {
    private final PluginAccessor pluginAccessor;

    private SafePluginPointAccess() {
        this.pluginAccessor = null;
    }

    private SafePluginPointAccess(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public static SafeAccessViaPluginAccessor to(PluginAccessor pluginAccessor) {
        return new SafePluginPointAccess(pluginAccessor);
    }

    public static SafeAccess to() {
        return new SafePluginPointAccess();
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> List<RT> forType(Class<D> moduleDescriptorClass, PluginPointFunction<D, MT, RT> callback) {
        List<D> moduleDescriptors = this.getModuleDescriptors(moduleDescriptorClass);
        return this.descriptors(moduleDescriptors, callback);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> void forType(Class<D> moduleDescriptorClass, PluginPointVisitor<D, MT> visitor) {
        List<D> moduleDescriptors = this.getModuleDescriptors(moduleDescriptorClass);
        this.descriptors(moduleDescriptors, visitor);
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> Either<? extends ModuleAccessError, RT> forKey(String moduleKey, Class<D> moduleDescriptorClass, PluginPointFunction<D, MT, RT> callback) {
        AccumulatingVisitor visitor = new AccumulatingVisitor(callback);
        Option<ModuleAccessError> result = this.forKey(moduleKey, moduleDescriptorClass, visitor);
        if (result.isDefined()) {
            return Either.left((Object)result.get());
        }
        return Either.right(visitor.getResults().get(0));
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> Option<? extends ModuleAccessError> forKey(String moduleKey, Class<D> moduleDescriptorClass, PluginPointVisitor<D, MT> visitor) {
        ModuleDescriptor temp = this.pluginAccessor.getEnabledPluginModule(moduleKey);
        if (temp == null) {
            return Option.some((Object)new ModuleNotFoundError());
        }
        if (moduleDescriptorClass.isAssignableFrom(temp.getClass())) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)moduleDescriptorClass.cast(temp);
            return this.descriptor(moduleDescriptor, visitor);
        }
        return Option.some((Object)new IncorrectModuleTypeError());
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> List<RT> descriptors(Iterable<D> moduleDescriptors, PluginPointFunction<D, MT, RT> callback) {
        AccumulatingVisitor visitor = new AccumulatingVisitor(callback);
        this.descriptors(moduleDescriptors, visitor);
        return visitor.getResults();
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> RT descriptor(D moduleDescriptor, PluginPointFunction<D, MT, RT> callback) {
        List<RT> result = this.descriptors(this.singleList(moduleDescriptor), callback);
        return result.isEmpty() ? null : (RT)result.get(0);
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> List<RT> modules(Iterable<MT> modules, PluginPointFunction<D, MT, RT> callback) {
        AccumulatingVisitor visitor = new AccumulatingVisitor(callback);
        this.modules(modules, visitor);
        return visitor.getResults();
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> RT module(MT module, PluginPointFunction<D, MT, RT> callback) {
        List<RT> result = this.modules(this.singleList(module), callback);
        return result.isEmpty() ? null : (RT)result.get(0);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> List<Option<? extends ModuleAccessError>> descriptors(Iterable<D> moduleDescriptors, PluginPointVisitor<D, MT> visitor) {
        ArrayList errors = Lists.newArrayList();
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor == null) {
                errors.add(Option.some((Object)new ModuleNotFoundError()));
                continue;
            }
            Object module = null;
            try {
                module = moduleDescriptor.getModule();
            }
            catch (ClassCastException e) {
                errors.add(Option.some((Object)new IncorrectModuleTypeError()));
            }
            catch (Throwable t) {
                SafePluginPointAccess.handleException(t, moduleDescriptor);
                errors.add(Option.some((Object)new ModuleExceptionError(t)));
                continue;
            }
            errors.add(this.invokeModule(visitor, moduleDescriptor, module));
        }
        return ImmutableList.copyOf((Iterable)errors);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> Option<? extends ModuleAccessError> descriptor(D moduleDescriptor, PluginPointVisitor<D, MT> visitor) {
        return this.descriptors(this.singleList(moduleDescriptor), visitor).get(0);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> Option<? extends ModuleAccessError> module(MT module, PluginPointVisitor<D, MT> visitor) {
        return this.modules(this.singleList(module), visitor).get(0);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> List<Option<? extends ModuleAccessError>> modules(Iterable<MT> modules, PluginPointVisitor<D, MT> visitor) {
        ArrayList errors = Lists.newArrayList();
        for (MT module : modules) {
            if (module == null) {
                errors.add(Option.some((Object)new ModuleNotFoundError()));
                continue;
            }
            errors.add(this.invokeModule(visitor, null, module));
        }
        return ImmutableList.copyOf((Iterable)errors);
    }

    @Override
    @Deprecated
    @Nullable
    public <RT> RT callable(Callable<RT> callable) {
        return (RT)SafePluginPointAccess.call(callable).getOrNull();
    }

    public static <RT> Option<RT> call(Callable<RT> callable) {
        try {
            return Option.option(callable.call());
        }
        catch (Throwable t) {
            SafePluginPointAccess.handleException(t);
            return Option.none();
        }
    }

    @Override
    public void runnable(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            SafePluginPointAccess.handleException(t);
        }
    }

    public static <T> Predicate<T> safe(final Predicate<T> base) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                try {
                    return base.apply(input);
                }
                catch (Throwable t) {
                    SafePluginPointAccess.handleException(t);
                    return false;
                }
            }
        };
    }

    public static <T> Supplier<T> safe(final Supplier<T> base) {
        return new Supplier<T>(){

            public T get() {
                try {
                    return base.get();
                }
                catch (Throwable t) {
                    return SafePluginPointAccess.handleException(t);
                }
            }
        };
    }

    public static <F, T> Function<F, T> safe(final Function<F, T> base) {
        return new Function<F, T>(){

            public T apply(F from) {
                try {
                    return base.apply(from);
                }
                catch (Throwable t) {
                    return SafePluginPointAccess.handleException(t);
                }
            }
        };
    }

    @Nullable
    public static <T> T handleError(Error e, ModuleDescriptor moduleDescriptor, Object module) throws Error {
        if (e instanceof LinkageError) {
            String msg = moduleDescriptor == null ? String.format("%s Unable to run plugin code because of '%s - %s'.", ThrowableLogger.LINKAGE_ERROR_MESSAGE, ThrowableLogger.getClassName(e), e.getMessage()) : (module == null ? String.format("%s This is for descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", ThrowableLogger.LINKAGE_ERROR_MESSAGE, SafePluginPointAccess.completeKey(moduleDescriptor), ThrowableLogger.getClassName(moduleDescriptor), ThrowableLogger.getClassName(e), e.getMessage()) : String.format("%s Unable to access module of type '%s' in descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", ThrowableLogger.LINKAGE_ERROR_MESSAGE, ThrowableLogger.getClassName(module), SafePluginPointAccess.completeKey(moduleDescriptor), ThrowableLogger.getClassName(moduleDescriptor), ThrowableLogger.getClassName(e), e.getMessage()));
            ThrowableLogger.logThrowable(msg, e, SafePluginPointAccess.getLogger(moduleDescriptor, module));
            return null;
        }
        throw e;
    }

    @Nullable
    public static <T> T handleException(Throwable e, ModuleDescriptor moduleDescriptor, Object module) throws Error {
        if (e instanceof Error) {
            return SafePluginPointAccess.handleError((Error)e, moduleDescriptor, module);
        }
        String msg = moduleDescriptor == null ? String.format("Unable to run plugin code because of '%s - %s'.", ThrowableLogger.getClassName(e), e.getMessage()) : (module == null ? String.format("Unable to access module for descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", SafePluginPointAccess.completeKey(moduleDescriptor), ThrowableLogger.getClassName(moduleDescriptor), ThrowableLogger.getClassName(e), e.getMessage()) : String.format("Unable to access module of type '%s' in descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", ThrowableLogger.getClassName(module), SafePluginPointAccess.completeKey(moduleDescriptor), ThrowableLogger.getClassName(moduleDescriptor), ThrowableLogger.getClassName(e), e.getMessage()));
        ThrowableLogger.logThrowable(msg, e, SafePluginPointAccess.getLogger(moduleDescriptor, module));
        return null;
    }

    @Nullable
    public static <T> T handleError(Error e) throws Error {
        return SafePluginPointAccess.handleError(e, null, null);
    }

    @Nullable
    public static <T> T handleError(Error e, ModuleDescriptor moduleDescriptor) throws Error {
        return SafePluginPointAccess.handleError(e, moduleDescriptor, null);
    }

    @Nullable
    public static <T> T handleException(Throwable e) throws Error {
        return SafePluginPointAccess.handleException(e, null, null);
    }

    @Nullable
    public static <T> T handleException(Throwable e, ModuleDescriptor moduleDescriptor) throws Error {
        return SafePluginPointAccess.handleException(e, moduleDescriptor, null);
    }

    private <MT, D extends ModuleDescriptor<MT>> Option<? extends ModuleAccessError> invokeModule(PluginPointVisitor<D, MT> visitor, D moduleDescriptor, MT module) {
        try {
            visitor.visit(moduleDescriptor, module);
            return Option.none();
        }
        catch (Throwable t) {
            SafePluginPointAccess.handleException(t);
            return Option.some((Object)new ModuleExceptionError(t));
        }
    }

    private <MT, D extends ModuleDescriptor<MT>> List<D> getModuleDescriptors(Class<D> moduleDescriptorClass) {
        if (this.pluginAccessor == null) {
            throw new IllegalStateException("If you are going to call on the PluginAccessor then you must build this object with one!");
        }
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(moduleDescriptorClass);
    }

    private static <D extends ModuleDescriptor<MT>, MT> Logger getLogger(D moduleDescriptor, MT module) {
        Class<Object> logClass = module != null ? module.getClass() : (moduleDescriptor != null ? moduleDescriptor.getClass() : SafePluginPointAccess.class);
        return LoggerFactory.getLogger(logClass);
    }

    private static <MT, D extends ModuleDescriptor<MT>> String completeKey(D moduleDescriptor) {
        if (moduleDescriptor == null) {
            return "NULL";
        }
        return moduleDescriptor.getCompleteKey();
    }

    private <MT> ArrayList<MT> singleList(MT module) {
        ArrayList<MT> modules = new ArrayList<MT>();
        modules.add(module);
        return modules;
    }

    private static class AccumulatingVisitor<D extends ModuleDescriptor<MT>, MT, RT>
    implements PluginPointVisitor<D, MT> {
        private final List<RT> results = Lists.newArrayList();
        private final PluginPointFunction<D, MT, RT> callback;

        private AccumulatingVisitor(PluginPointFunction<D, MT, RT> callback) {
            this.callback = callback;
        }

        @Override
        public void visit(D moduleDescriptor, MT module) {
            RT result = this.callback.onModule(moduleDescriptor, module);
            this.results.add(result);
        }

        private List<RT> getResults() {
            return this.results;
        }
    }
}

