package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.cache.CacheHandle;

import java.util.Map;

/**
 * Represents a batch download of all the resources in a web-resource module of a plugin. <p/>
 *
 * @since 2.2
 */
public class BatchDownloadableResource extends AbstractBatchDownloadableResource
{
    private final String moduleCompleteKey;

    /**
     * This constructor should only ever be used internally within this class. It does not ensure that the resourceName's
     * file extension is the same as the given type. It is up to the calling code to ensure this.
     * @param type - the type of resource (CSS/JS)
     * @param params - the parameters of the resource (ieonly, media, etc)
     * @param resources - the resources included in the batch.
     */
    BatchDownloadableResource(final String moduleCompleteKey, final String type, final Map<String, String> params,
                              final Iterable<DownloadableResource> resources, final CacheHandle cacher, 
                              final ResourceBatchingConfiguration resourceBatchingConfiguration)
    {
        super(type, params, resources, cacher, resourceBatchingConfiguration);
        this.moduleCompleteKey = moduleCompleteKey;
    }

    public String getModuleCompleteKey() {
        return moduleCompleteKey;
    }

    @Override
    public String toString()
    {
        return "[moduleCompleteKey=" + moduleCompleteKey + ", type=" + getType() + ", params=" + getParams() + "]";
    }
}
