package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginCssResourceParams;

/**
 * Implementation of PluginUrlResource
 * @since 3.0
 */
class DefaultPluginCssResource extends DefaultPluginUrlResource<PluginCssResourceParams> implements PluginCssResource
{
    public DefaultPluginCssResource(WebResourceIntegration webResourceIntegration,
        WebResourceUrlProvider webResourceUrlProvider, PluginResource pluginResource)
    {
        super(webResourceIntegration, webResourceUrlProvider, pluginResource);
    }

    @Override
    public PluginCssResourceParams getParams()
    {
        return new DefaultPluginCssResourceParams(pluginResource.getParams());
    }
}
