package com.atlassian.plugin.webresource.url;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * Implementation of UrlBuilder
 *
 * @since v3.0
 */
public class DefaultUrlBuilder implements UrlBuilder
{
    private final List<NamedHash> hashes;
    private final Map<String, String> queryString;
    private CDNSupport cdn = CDNSupport.OK;

    public DefaultUrlBuilder()
    {
        this.hashes = Lists.newLinkedList();
        this.queryString = Maps.newLinkedHashMap();
    }

    @Override
    public void addToHash(String name, Object value)
    {
        hashes.add(new NamedHash(name, value.toString()));
    }

    @Override
    public void addToQueryString(String key, String value)
    {
        queryString.put(key, value);
    }

    /** Mark this resource as not deliverable via CDN */
    public void taint()
    {
        cdn = CDNSupport.Tainted;
    }

    public UrlParameters build()
    {
        return UrlParameters.of(cdn, hashes, queryString);
    }
}
