package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nullable;

/**
 * The essential data of a whitelist rule which is persisted in the database.
 * @since 1.0
 */
@PublicApi
public interface WhitelistRule
{
    /**
     * @return the id of the whitelist rule; <code>null</code> if not yet persisted
     */
    @Nullable
    Integer getId();

    /**
     * @return an whitelist rule expression; can have a specific meaning depending on the type.
     */
    String getExpression();

    /**
     * @return the whitelist rule type
     */
    WhitelistType getType();

    /**
     * @return <code>true</code> if the whitelist rule represents inbound requests as well as outbound requests, <code>false</code> otherwise
     */
    boolean isAllowInbound();
}
