/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 2002, 2013 Oracle and/or its affiliates.  All rights reserved.
 *
 */

package com.sleepycat.utilint;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class IsoDateTime {

    private final Calendar calendar =
        new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final StringBuffer buffer = new StringBuffer();

    /**
     * Generate a ISO 8601 datetime string
     * @param millis millis since epoch
     * @return a string representing the date in the ISO 8601 format
     */
    public String getIsoDateTime(long millis) {
        buffer.setLength(0);
        calendar.setTimeInMillis(millis);
        buffer.append(calendar.get(Calendar.YEAR));
        buffer.append("-");
        buffer.append(pad(calendar.get(Calendar.MONTH) + 1));
        buffer.append("-");
        buffer.append(pad(calendar.get(Calendar.DAY_OF_MONTH)));
        buffer.append("T");
        buffer.append(pad(calendar.get(Calendar.HOUR_OF_DAY)));
        buffer.append(":");
        buffer.append(pad(calendar.get(Calendar.MINUTE)));
        buffer.append(":");
        buffer.append(pad(calendar.get(Calendar.SECOND)));
        buffer.append("Z");
        return buffer.toString();
    }

    private static String pad(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }
}
