/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class TrashPolicy
extends Configured {
    protected FileSystem fs;
    protected Path trash;
    protected long deletionInterval;

    public abstract void initialize(Configuration var1, FileSystem var2, Path var3);

    public void initialize(Configuration conf, FileSystem fs) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isEnabled();

    public abstract boolean moveToTrash(Path var1) throws IOException;

    public abstract void createCheckpoint() throws IOException;

    public abstract void deleteCheckpoint() throws IOException;

    public abstract Path getCurrentTrashDir();

    public Path getCurrentTrashDir(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract Runnable getEmptier() throws IOException;

    public static TrashPolicy getInstance(Configuration conf, FileSystem fs, Path home) {
        Class<TrashPolicy> trashClass = conf.getClass("fs.trash.classname", TrashPolicyDefault.class, TrashPolicy.class);
        TrashPolicy trash = ReflectionUtils.newInstance(trashClass, conf);
        trash.initialize(conf, fs, home);
        return trash;
    }

    public static TrashPolicy getInstance(Configuration conf, FileSystem fs) {
        Class<TrashPolicy> trashClass = conf.getClass("fs.trash.classname", TrashPolicyDefault.class, TrashPolicy.class);
        TrashPolicy trash = ReflectionUtils.newInstance(trashClass, conf);
        trash.initialize(conf, fs);
        return trash;
    }
}

