/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteCredentialsCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store Id", required=true)
    public CredentialsStore store;
    @Argument(metaVar="DOMAIN", usage="Domain Name", required=true, index=1)
    public String domain;
    @Argument(metaVar="CREDENTIAL", usage="Credential Id", required=true, index=2)
    public String id;

    public String getShortDescription() {
        return Messages.DeleteCredentialsCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.DELETE);
        Domain domain = DeleteCredentialsCommand.getDomainByName(this.store, this.domain);
        if (domain == null) {
            this.stderr.println("No such domain");
            return 2;
        }
        Credentials existing = DeleteCredentialsCommand.getCredentialsById(this.store, domain, this.id);
        if (existing == null) {
            this.stderr.println("No such credential");
            return 3;
        }
        if (this.store.removeCredentials(domain, existing)) {
            return 0;
        }
        this.stderr.println("Not deleted");
        return 1;
    }
}

