/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.SignTool;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCreditsParams {
    private String appKey;
    private Date timestamp;
    private Long credits;
    private String orderNum = "";
    private String description = "";
    private String type = "";
    private String uid = "";
    private String ip = "";
    private String transfer = "";

    public Map<String, String> toRequestMap(String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("credits", this.credits + "");
        map.put("description", this.description);
        map.put("uid", this.uid);
        map.put("appKey", this.appKey);
        map.put("appSecret", appSecret);
        map.put("timestamp", System.currentTimeMillis() + "");
        map.put("orderNum", this.orderNum);
        map.put("type", this.type);
        map.put("ip", this.ip);
        this.putIfNotEmpty(map, "transfer", this.transfer);
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private void putIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        map.put(key, value);
    }

    public Long getCredits() {
        return this.credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }
}

