/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.SignTool;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditConsumeParams {
    private String appKey;
    private Date timestamp;
    private Long credits;
    private String orderNum = "";
    private String description = "";
    private String itemCode = "";
    private String type = "";
    private Integer facePrice = 0;
    private Integer actualPrice = 0;
    private String alipay = "";
    private String phone = "";
    private String qq = "";
    private String uid = "";
    private boolean waitAudit = false;
    private String ip = "";
    private String params = "";
    private String transfer = "";
    private String isGreenActivity = "";

    public Map<String, String> toRequestMap(String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("credits", this.credits + "");
        map.put("description", this.description);
        map.put("uid", this.uid);
        map.put("appKey", this.appKey);
        map.put("waitAudit", this.waitAudit + "");
        map.put("appSecret", appSecret);
        map.put("timestamp", System.currentTimeMillis() + "");
        map.put("orderNum", this.orderNum);
        map.put("type", this.type);
        map.put("facePrice", this.facePrice + "");
        map.put("actualPrice", this.actualPrice + "");
        map.put("ip", this.ip);
        map.put("params", this.params);
        map.put("isGreenActivity", this.isGreenActivity);
        this.putIfNotEmpty(map, "itemCode", this.itemCode);
        this.putIfNotEmpty(map, "transfer", this.transfer);
        this.putIfNotEmpty(map, "qq", this.qq);
        this.putIfNotEmpty(map, "alipay", this.alipay);
        this.putIfNotEmpty(map, "phone", this.phone);
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private void putIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        map.put(key, value);
    }

    public Long getCredits() {
        return this.credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public boolean isWaitAudit() {
        return this.waitAudit;
    }

    public void setWaitAudit(boolean waitAudit) {
        this.waitAudit = waitAudit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getFacePrice() {
        return this.facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Integer getActualPrice() {
        return this.actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

    public String getAlipay() {
        return this.alipay;
    }

    public void setAlipay(String alipay) {
        this.alipay = alipay;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getQq() {
        return this.qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public String getIsGreenActivity() {
        return this.isGreenActivity;
    }

    public void setIsGreenActivity(String isGreenActivity) {
        this.isGreenActivity = isGreenActivity;
    }
}

