/*
 * Decompiled with CFR 0.152.
 */
package com.hualala.api.utils;

import com.hualala.api.model.SignModel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignUtil {
    public static final String SIGNATURE_SECRET_KEY = "appSecret";
    public static final String SIGNATURE_PREFIX = "key";
    public static final String SIGNATURE_SUFFIX = "secret";
    public static final String NOT_CONTAIN_SIGN = "signature";

    public static String getObjectSign(Object object, String devPwd, String logPrefix) throws Exception {
        try {
            Map<String, Object> fieldMap = new TreeMap<String, Object>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            fieldMap = SignUtil.getPropertyObject(object, fieldMap);
            fieldMap.put(SIGNATURE_SECRET_KEY, devPwd);
            if (fieldMap.size() <= 0) {
                return null;
            }
            StringBuilder loggerSb = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            sb.append(SIGNATURE_PREFIX);
            for (String key : fieldMap.keySet()) {
                Object fieldValue = fieldMap.get(key);
                sb.append(key).append(fieldValue);
                if (logPrefix == null || "".equals(logPrefix)) {
                    loggerSb.append(logPrefix + " ");
                }
                loggerSb.append(key + ": " + fieldValue + " ");
            }
            sb.append(SIGNATURE_SUFFIX);
            String generatorStr = sb.toString();
            String generatorSig = SignUtil.getSha1(generatorStr);
            return generatorSig;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static Map<String, Object> getPropertyObject(Object field, Map<String, Object> treeMap) throws Exception {
        boolean isBaseTypeObjec = SignUtil.isBaseTypeObject(field);
        if (isBaseTypeObjec) {
            return treeMap;
        }
        for (Class<?> sub = field.getClass(); sub != Object.class; sub = sub.getSuperclass()) {
            Field[] subFields = sub.getDeclaredFields();
            for (int i = 0; i < subFields.length; ++i) {
                Field currtField = subFields[i];
                Boolean sc = currtField.isAccessible();
                currtField.setAccessible(true);
                if (currtField.getType().isAssignableFrom(List.class)) {
                    List listClass = (List)currtField.get(field);
                    if (listClass == null || listClass.size() <= 0) continue;
                    treeMap = SignUtil.getPropertyObject(listClass.get(0), treeMap);
                    continue;
                }
                boolean isBaseType = SignUtil.isBaseType(currtField);
                if (!isBaseType && currtField.get(field) != null) {
                    treeMap = SignUtil.getPropertyObject(currtField.get(field), treeMap);
                } else {
                    String sFieldName = currtField.getName();
                    Object sFieldValue = SignUtil.getFieldValueByName(sFieldName, field);
                    if (sFieldValue != null) {
                        treeMap.put(sFieldName, sFieldValue);
                    }
                }
                currtField.setAccessible(sc);
            }
        }
        return treeMap;
    }

    public static boolean isBaseType(Field field) {
        if (field.getType().isAssignableFrom(Integer.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Character.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Short.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Long.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Double.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Float.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Boolean.class)) {
            return true;
        }
        if (field.getType().isAssignableFrom(Byte.class)) {
            return true;
        }
        return field.getType().isAssignableFrom(String.class);
    }

    public static boolean isBaseTypeObject(Object object) {
        if (object instanceof Integer) {
            return true;
        }
        if (object instanceof Character) {
            return true;
        }
        if (object instanceof Short) {
            return true;
        }
        if (object instanceof Long) {
            return true;
        }
        if (object instanceof Double) {
            return true;
        }
        if (object instanceof Float) {
            return true;
        }
        if (object instanceof Byte) {
            return true;
        }
        return object instanceof String;
    }

    private static Object getFieldValueByName(String fieldName, Object obj) {
        Object value = null;
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = obj.getClass().getMethod(getter, new Class[0]);
            value = method.invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethod) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getSha1(String encryptStr) throws Exception {
        try {
            if (encryptStr == null || "".equals(encryptStr)) {
                return null;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(encryptStr.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public static SignModel getMapSign(Map<String, Object> paramMap, String devPwd) throws Exception {
        try {
            Map<String, Object> fieldMap = new TreeMap<String, Object>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            Set<String> keys = paramMap.keySet();
            if (keys.size() > 0) {
                for (String key : keys) {
                    if (key.equalsIgnoreCase(NOT_CONTAIN_SIGN)) continue;
                    boolean isBaseTypeObjec = SignUtil.isBaseTypeObject(paramMap.get(key));
                    if (isBaseTypeObjec) {
                        fieldMap.put(key, paramMap.get(key));
                        continue;
                    }
                    fieldMap = SignUtil.getPropertyObject(paramMap.get(key), fieldMap);
                }
            }
            fieldMap.put(SIGNATURE_SECRET_KEY, devPwd);
            StringBuilder loggerSb = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            sb.append(SIGNATURE_PREFIX);
            for (String key : fieldMap.keySet()) {
                Object fieldValue = fieldMap.get(key);
                sb.append(key).append(fieldValue);
            }
            sb.append(SIGNATURE_SUFFIX);
            String generatorStr = sb.toString();
            String generatorSig = SignUtil.getSha1(generatorStr);
            SignModel signModel = new SignModel();
            signModel.setGeneratorSig(generatorSig);
            signModel.setGeneratorStr(generatorStr);
            return signModel;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

