/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import java.util.List;
import java.util.stream.Collectors;

public abstract class KubernetesCachingAgent<C extends KubernetesCredentials>
implements CachingAgent,
AccountAware {
    protected final String accountName;
    protected final Registry registry;
    protected final C credentials;
    protected final ObjectMapper objectMapper;
    private final int agentIndex;
    private final int agentCount;
    protected List<String> namespaces;

    protected KubernetesCachingAgent(KubernetesNamedAccountCredentials<C> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        this.accountName = namedAccountCredentials.getName();
        this.credentials = namedAccountCredentials.getCredentials();
        this.objectMapper = objectMapper;
        this.registry = registry;
        this.agentIndex = agentIndex;
        this.agentCount = agentCount;
        this.reloadNamespaces();
    }

    public String getAgentType() {
        return String.format("%s/%s[%d/%d]", this.accountName, this.getClass().getSimpleName(), this.agentIndex + 1, this.agentCount);
    }

    protected void reloadNamespaces() {
        this.namespaces = this.credentials.getDeclaredNamespaces().stream().filter(n -> this.agentCount == 1 || Math.abs(n.hashCode() % this.agentCount) == this.agentIndex).collect(Collectors.toList());
    }

    public String getAccountName() {
        return this.accountName;
    }
}

