/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class KubernetesVersionedArtifactConverter
extends KubernetesArtifactConverter {
    @Override
    public Artifact toArtifact(ArtifactProvider provider, KubernetesManifest manifest) {
        String type = this.getType(manifest);
        String name = manifest.getName();
        String location = manifest.getNamespace();
        String version = this.getVersion(provider, type, name, location);
        return Artifact.builder().type(type).name(name).location(location).version(version).build();
    }

    @Override
    public KubernetesCoordinates toCoordinates(Artifact artifact) {
        return KubernetesCoordinates.builder().kind(this.getKind(artifact)).name(this.getDeployedName(artifact)).namespace(this.getNamespace(artifact)).build();
    }

    @Override
    public String getDeployedName(Artifact artifact) {
        return artifact.getName() + "-" + artifact.getVersion();
    }

    private String getVersion(ArtifactProvider provider, String type, String name, String location) {
        List priorVersions = provider.getArtifacts(type, name, location);
        List taken = priorVersions.stream().map(Artifact::getVersion).filter(Objects::nonNull).filter(v -> v.startsWith("v")).map(v -> v.substring(1)).map(v -> {
            try {
                return Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(i -> i >= 0).collect(Collectors.toList());
        taken.sort(Integer::compareTo);
        int sequence = 0;
        if (!taken.isEmpty()) {
            sequence = (Integer)taken.get(taken.size() - 1) + 1;
        }
        if (sequence < 1000) {
            return String.format("v%03d", sequence);
        }
        return String.format("v%d", sequence);
    }
}

