/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.SecurityGroup;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupSummary;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import io.kubernetes.client.models.V1NetworkPolicy;
import io.kubernetes.client.models.V1NetworkPolicyPort;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV2SecurityGroup
extends ManifestBasedModel
implements SecurityGroup {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2SecurityGroup.class);
    private KubernetesManifest manifest;
    private Keys.InfrastructureCacheKey key;
    private String id;
    private Set<Rule> inboundRules;
    private Set<Rule> outboundRules;

    public String getApplication() {
        return this.getMoniker().getApp();
    }

    public SecurityGroupSummary getSummary() {
        return KubernetesV2SecurityGroupSummary.builder().id(this.id).name(this.id).build();
    }

    KubernetesV2SecurityGroup(KubernetesManifest manifest, String key, Set<Rule> inboundRules, Set<Rule> outboundRules) {
        this.manifest = manifest;
        this.id = manifest.getFullResourceName();
        this.key = (Keys.InfrastructureCacheKey)Keys.parseKey(key).get();
        this.inboundRules = inboundRules;
        this.outboundRules = outboundRules;
    }

    public static KubernetesV2SecurityGroup fromCacheData(CacheData cd) {
        if (cd == null) {
            return null;
        }
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        HashSet<Rule> inboundRules = new HashSet();
        HashSet<Rule> outboundRules = new HashSet();
        if (manifest.getKind() != KubernetesKind.NETWORK_POLICY) {
            log.warn("Unknown security group kind " + manifest.getKind());
        } else if (manifest.getApiVersion().equals(KubernetesApiVersion.NETWORKING_K8S_IO_V1)) {
            V1NetworkPolicy v1beta1NetworkPolicy = KubernetesCacheDataConverter.getResource(manifest, V1NetworkPolicy.class);
            inboundRules = KubernetesV2SecurityGroup.inboundRules(v1beta1NetworkPolicy);
            outboundRules = KubernetesV2SecurityGroup.outboundRules(v1beta1NetworkPolicy);
        } else {
            log.warn("Could not determine (in)/(out)bound rules for " + manifest.getName() + " at version " + manifest.getApiVersion());
        }
        return new KubernetesV2SecurityGroup(manifest, cd.getId(), inboundRules, outboundRules);
    }

    private static Set<Rule> inboundRules(V1NetworkPolicy policy) {
        return policy.getSpec().getIngress().stream().map(i -> i.getPorts().stream().map(KubernetesV2SecurityGroup::fromPolicyPort)).flatMap(s -> s).collect(Collectors.toSet());
    }

    private static Set<Rule> outboundRules(V1NetworkPolicy policy) {
        return policy.getSpec().getEgress().stream().map(i -> i.getPorts().stream().map(KubernetesV2SecurityGroup::fromPolicyPort)).flatMap(s -> s).collect(Collectors.toSet());
    }

    private static Rule fromPolicyPort(V1NetworkPolicyPort policyPort) {
        String port = policyPort.getPort();
        return new PortRule().setProtocol(policyPort.getProtocol()).setPortRanges(new TreeSet<Rule.PortRange>(Collections.singletonList(new StringPortRange(port))));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2SecurityGroup)) {
            return false;
        }
        KubernetesV2SecurityGroup other = (KubernetesV2SecurityGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesManifest this$manifest = this.getManifest();
        KubernetesManifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        Keys.InfrastructureCacheKey this$key = this.getKey();
        Keys.InfrastructureCacheKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Set<Rule> this$inboundRules = this.getInboundRules();
        Set<Rule> other$inboundRules = other.getInboundRules();
        if (this$inboundRules == null ? other$inboundRules != null : !((Object)this$inboundRules).equals(other$inboundRules)) {
            return false;
        }
        Set<Rule> this$outboundRules = this.getOutboundRules();
        Set<Rule> other$outboundRules = other.getOutboundRules();
        return !(this$outboundRules == null ? other$outboundRules != null : !((Object)this$outboundRules).equals(other$outboundRules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2SecurityGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        KubernetesManifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        Keys.InfrastructureCacheKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Set<Rule> $inboundRules = this.getInboundRules();
        result = result * 59 + ($inboundRules == null ? 43 : ((Object)$inboundRules).hashCode());
        Set<Rule> $outboundRules = this.getOutboundRules();
        result = result * 59 + ($outboundRules == null ? 43 : ((Object)$outboundRules).hashCode());
        return result;
    }

    @Override
    public KubernetesManifest getManifest() {
        return this.manifest;
    }

    @Override
    public Keys.InfrastructureCacheKey getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public Set<Rule> getInboundRules() {
        return this.inboundRules;
    }

    public Set<Rule> getOutboundRules() {
        return this.outboundRules;
    }

    public KubernetesV2SecurityGroup setManifest(KubernetesManifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public KubernetesV2SecurityGroup setKey(Keys.InfrastructureCacheKey key) {
        this.key = key;
        return this;
    }

    public KubernetesV2SecurityGroup setId(String id) {
        this.id = id;
        return this;
    }

    public KubernetesV2SecurityGroup setInboundRules(Set<Rule> inboundRules) {
        this.inboundRules = inboundRules;
        return this;
    }

    public KubernetesV2SecurityGroup setOutboundRules(Set<Rule> outboundRules) {
        this.outboundRules = outboundRules;
        return this;
    }

    public String toString() {
        return "KubernetesV2SecurityGroup(manifest=" + this.getManifest() + ", key=" + this.getKey() + ", id=" + this.getId() + ", inboundRules=" + this.getInboundRules() + ", outboundRules=" + this.getOutboundRules() + ")";
    }

    public static class StringPortRange
    extends Rule.PortRange {
        protected String startPortName;
        protected String endPortName;

        StringPortRange(String port) {
            try {
                Integer numPort;
                this.startPort = numPort = Integer.valueOf(Integer.parseInt(port));
                this.endPort = numPort;
            }
            catch (Exception e) {
                this.startPortName = port;
                this.endPortName = port;
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringPortRange)) {
                return false;
            }
            StringPortRange other = (StringPortRange)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$startPortName = this.getStartPortName();
            String other$startPortName = other.getStartPortName();
            if (this$startPortName == null ? other$startPortName != null : !this$startPortName.equals(other$startPortName)) {
                return false;
            }
            String this$endPortName = this.getEndPortName();
            String other$endPortName = other.getEndPortName();
            return !(this$endPortName == null ? other$endPortName != null : !this$endPortName.equals(other$endPortName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StringPortRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            String $startPortName = this.getStartPortName();
            result = result * 59 + ($startPortName == null ? 43 : $startPortName.hashCode());
            String $endPortName = this.getEndPortName();
            result = result * 59 + ($endPortName == null ? 43 : $endPortName.hashCode());
            return result;
        }

        public String getStartPortName() {
            return this.startPortName;
        }

        public String getEndPortName() {
            return this.endPortName;
        }

        public StringPortRange setStartPortName(String startPortName) {
            this.startPortName = startPortName;
            return this;
        }

        public StringPortRange setEndPortName(String endPortName) {
            this.endPortName = endPortName;
            return this;
        }

        public String toString() {
            return "KubernetesV2SecurityGroup.StringPortRange(startPortName=" + this.getStartPortName() + ", endPortName=" + this.getEndPortName() + ")";
        }
    }

    private static class PortRule
    implements Rule {
        private SortedSet<Rule.PortRange> portRanges;
        private String protocol;

        public SortedSet<Rule.PortRange> getPortRanges() {
            return this.portRanges;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public PortRule setPortRanges(SortedSet<Rule.PortRange> portRanges) {
            this.portRanges = portRanges;
            return this;
        }

        public PortRule setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PortRule)) {
                return false;
            }
            PortRule other = (PortRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SortedSet<Rule.PortRange> this$portRanges = this.getPortRanges();
            SortedSet<Rule.PortRange> other$portRanges = other.getPortRanges();
            if (this$portRanges == null ? other$portRanges != null : !this$portRanges.equals(other$portRanges)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PortRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SortedSet<Rule.PortRange> $portRanges = this.getPortRanges();
            result = result * 59 + ($portRanges == null ? 43 : $portRanges.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            return result;
        }

        public String toString() {
            return "KubernetesV2SecurityGroup.PortRule(portRanges=" + this.getPortRanges() + ", protocol=" + this.getProtocol() + ")";
        }
    }

    private static class KubernetesV2SecurityGroupSummary
    implements SecurityGroupSummary {
        private String name;
        private String id;

        public static KubernetesV2SecurityGroupSummaryBuilder builder() {
            return new KubernetesV2SecurityGroupSummaryBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public KubernetesV2SecurityGroupSummary setName(String name) {
            this.name = name;
            return this;
        }

        public KubernetesV2SecurityGroupSummary setId(String id) {
            this.id = id;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KubernetesV2SecurityGroupSummary)) {
                return false;
            }
            KubernetesV2SecurityGroupSummary other = (KubernetesV2SecurityGroupSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KubernetesV2SecurityGroupSummary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "KubernetesV2SecurityGroup.KubernetesV2SecurityGroupSummary(name=" + this.getName() + ", id=" + this.getId() + ")";
        }

        public KubernetesV2SecurityGroupSummary() {
        }

        @ConstructorProperties(value={"name", "id"})
        public KubernetesV2SecurityGroupSummary(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public static class KubernetesV2SecurityGroupSummaryBuilder {
            private String name;
            private String id;

            KubernetesV2SecurityGroupSummaryBuilder() {
            }

            public KubernetesV2SecurityGroupSummaryBuilder name(String name) {
                this.name = name;
                return this;
            }

            public KubernetesV2SecurityGroupSummaryBuilder id(String id) {
                this.id = id;
                return this;
            }

            public KubernetesV2SecurityGroupSummary build() {
                return new KubernetesV2SecurityGroupSummary(this.name, this.id);
            }

            public String toString() {
                return "KubernetesV2SecurityGroup.KubernetesV2SecurityGroupSummary.KubernetesV2SecurityGroupSummaryBuilder(name=" + this.name + ", id=" + this.id + ")";
            }
        }
    }
}

