/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.model.ManifestProvider;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ManifestProvider
implements ManifestProvider<KubernetesV2Manifest> {
    private final KubernetesResourcePropertyRegistry registry;
    private final KubernetesCacheUtils cacheUtils;

    @Autowired
    public KubernetesV2ManifestProvider(KubernetesResourcePropertyRegistry registry, KubernetesCacheUtils cacheUtils) {
        this.registry = registry;
        this.cacheUtils = cacheUtils;
    }

    public KubernetesV2Manifest getManifest(String account, String location, String name) {
        Pair<KubernetesKind, String> parsedName;
        try {
            parsedName = KubernetesManifest.fromFullResourceName(name);
        }
        catch (Exception e) {
            return null;
        }
        KubernetesKind kind = (KubernetesKind)parsedName.getLeft();
        String key = Keys.infrastructure(kind, account, location, (String)parsedName.getRight());
        Optional<CacheData> dataOptional = this.cacheUtils.getSingleEntry(kind.toString(), key);
        if (!dataOptional.isPresent()) {
            return null;
        }
        CacheData data = dataOptional.get();
        KubernetesHandler deployer = this.registry.get(kind).getHandler();
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(data);
        Moniker moniker = KubernetesCacheDataConverter.getMoniker(data);
        new KubernetesV2Manifest();
        return KubernetesV2Manifest.builder().account(account).location(location).manifest(manifest).moniker(moniker).status(deployer.status(manifest)).artifacts(deployer.listArtifacts(manifest)).build();
    }
}

