/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactDownloader;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestSpinnakerRelationships;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import com.netflix.spinnaker.moniker.Namer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class KubernetesDeployManifestOperation
implements AtomicOperation<OperationResult> {
    private final KubernetesDeployManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final ArtifactDownloader artifactDownloader;
    private final ArtifactProvider provider;
    private final Namer namer;
    private final KubernetesResourcePropertyRegistry registry;
    private static final String OP_NAME = "DEPLOY_KUBERNETES_MANIFEST";

    public KubernetesDeployManifestOperation(KubernetesDeployManifestDescription description, KubernetesResourcePropertyRegistry registry, ArtifactProvider provider, ArtifactDownloader artifactDownloader) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
        this.provider = provider;
        this.artifactDownloader = artifactDownloader;
        this.namer = NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(description.getCredentials().getName()).withResource(KubernetesManifest.class);
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List _unused) {
        List<Artifact> artifacts;
        KubernetesManifest manifest;
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Beginning deployment of manifest...");
        KubernetesDeployManifestDescription.Source source = this.description.getSource();
        source = source == null ? KubernetesDeployManifestDescription.Source.text : source;
        switch (source) {
            case text: {
                manifest = this.description.getManifest();
                break;
            }
            case artifact: {
                try {
                    manifest = (KubernetesManifest)this.artifactDownloader.downloadAsYaml(this.description.getManifestArtifact(), KubernetesManifest.class);
                    break;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to fetch artifact '" + this.description.getManifestArtifact() + "'", e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported artifact source: " + (Object)((Object)source));
            }
        }
        if (StringUtils.isEmpty((String)manifest.getNamespace())) {
            manifest.setNamespace(this.credentials.getDefaultNamespace());
        }
        if ((artifacts = this.description.getArtifacts()) == null) {
            artifacts = new ArrayList<Artifact>();
        }
        KubernetesResourceProperties properties = this.findResourceProperties(manifest);
        boolean versioned = this.description.getVersioned() == null ? properties.isVersioned() : this.description.getVersioned().booleanValue();
        KubernetesArtifactConverter converter = versioned ? properties.getVersionedConverter() : properties.getUnversionedConverter();
        KubernetesHandler deployer = properties.getHandler();
        Artifact artifact = converter.toArtifact(this.provider, manifest);
        Moniker moniker = this.description.getMoniker();
        KubernetesManifestSpinnakerRelationships relationships = this.description.getRelationships();
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Annotating manifest with artifact, relationships & moniker...");
        KubernetesManifestAnnotater.annotateManifest(manifest, artifact);
        KubernetesManifestAnnotater.annotateManifest(manifest, relationships);
        this.namer.applyMoniker((Object)manifest, moniker);
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Setting a resource name...");
        manifest.setName(converter.getDeployedName(artifact));
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Swapping out artifacts from context...");
        ArtifactReplacer.ReplaceResult replaceResult = deployer.replaceArtifacts(manifest, artifacts);
        manifest = replaceResult.getManifest();
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Submitting manifest to kubernetes master...");
        OperationResult result = deployer.deployAugmentedManifest(this.credentials, manifest);
        result.getCreatedArtifacts().add(artifact);
        result.getBoundArtifacts().addAll(replaceResult.getBoundArtifacts());
        return result;
    }

    private KubernetesResourceProperties findResourceProperties(KubernetesManifest manifest) {
        KubernetesKind kind = manifest.getKind();
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Finding deployer for " + kind + "...");
        return this.registry.get(kind);
    }
}

