/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesScaleManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesScaleManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesScaleManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private static final String OP_NAME = "SCALE_KUBERNETES_MANIFEST";

    public KubernetesScaleManifestOperation(KubernetesScaleManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        KubernetesScaleManifestOperation.getTask().updateStatus(OP_NAME, "Starting scale operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesScaleManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesResourceProperties properties = this.registry.get(coordinates.getKind());
        KubernetesHandler deployer = properties.getHandler();
        if (!(deployer instanceof CanScale)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support scale");
        }
        CanScale canScale = (CanScale)((Object)deployer);
        KubernetesScaleManifestOperation.getTask().updateStatus(OP_NAME, "Calling scale operation...");
        canScale.scale(this.credentials, coordinates.getNamespace(), coordinates.getName(), this.description.getReplicas());
        return null;
    }
}

