/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.KubeConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesApiClientConfig
extends Config
implements GroovyObject {
    private String configKey;
    private String context;
    private String cluster;
    private String user;
    private String userAgent;
    private Boolean serviceAccount;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public KubernetesApiClientConfig(String string, String string2, String string3, String string4, String string5, Boolean bl) {
        void serviceAccount;
        void userAgent;
        void user;
        void context;
        void configKey;
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var9_9 = configKey;
        this.configKey = ShortTypeHandling.castToString((Object)var9_9);
        void var10_10 = context;
        this.context = ShortTypeHandling.castToString((Object)var10_10);
        void var11_11 = user;
        this.user = ShortTypeHandling.castToString((Object)var11_11);
        void var12_12 = userAgent;
        this.userAgent = ShortTypeHandling.castToString((Object)var12_12);
        void var13_13 = serviceAccount;
        this.serviceAccount = (Boolean)ScriptBytecodeAdapter.castToType((Object)var13_13, Boolean.class);
    }

    public ApiClient getApiCient() throws Exception {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccount)) {
                return (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callCurrent((GroovyObject)this), ApiClient.class);
            }
            return (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callCurrent((GroovyObject)this), ApiClient.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccount)) {
            return this.withServiceAccount();
        }
        return this.withKubeConfig();
    }

    public ApiClient withServiceAccount() {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        ApiClient client = (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(ApiClient.class), ApiClient.class);
        try {
            boolean serviceAccountCaCertExists = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(Files.class, callSiteArray[4].call(callSiteArray[5].callConstructor(File.class, callSiteArray[6].callGetProperty(io.fabric8.kubernetes.client.Config.class)))));
            if (!serviceAccountCaCertExists) {
                throw (Throwable)callSiteArray[10].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Could not find CA cert for service account at ", ""}));
            }
            callSiteArray[7].call((Object)client, callSiteArray[8].callConstructor(FileInputStream.class, callSiteArray[9].callGetProperty(io.fabric8.kubernetes.client.Config.class)));
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[12].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[13].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Could not find CA cert for service account at ", ""}), (Object)e);
        }
        try {
            String serviceTokenCandidate = ShortTypeHandling.castToString((Object)callSiteArray[14].callConstructor(String.class, callSiteArray[15].call(Files.class, callSiteArray[16].call(callSiteArray[17].callConstructor(File.class, callSiteArray[18].callGetProperty(io.fabric8.kubernetes.client.Config.class))))));
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)serviceTokenCandidate, null)) {
                throw (Throwable)callSiteArray[21].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[22].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Did not find service account token at ", ""}));
            }
            callSiteArray[19].call((Object)client, callSiteArray[20].call((Object)"Bearer ", (Object)serviceTokenCandidate));
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[23].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[24].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Could not read service account token at ", ""}), (Object)e);
        }
        return client;
    }

    public ApiClient withKubeConfig() {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        KubeConfig kubeconfig = null;
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[25].callStatic(KubernetesApiClientConfig.class, (Object)this.configKey);
                kubeconfig = (KubeConfig)ScriptBytecodeAdapter.castToType((Object)object, KubeConfig.class);
            } else {
                KubeConfig kubeConfig;
                kubeconfig = kubeConfig = KubernetesApiClientConfig.parseConfig(this.configKey);
            }
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[26].callConstructor(IllegalStateException.class, callSiteArray[27].call(callSiteArray[28].call((Object)"Parse config", (Object)this.configKey), (Object)"failed"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call(StringUtils.class, (Object)this.context)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].callGetProperty((Object)kubeconfig))) {
            throw (Throwable)callSiteArray[31].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{this.context}, new String[]{"Missing required field ", " in kubeconfig file and clouddriver configuration."}));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call(StringUtils.class, (Object)this.context))) {
            callSiteArray[33].call((Object)kubeconfig, (Object)this.context);
        }
        ApiClient client = (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(Config.class, (Object)kubeconfig), ApiClient.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call(StringUtils.class, (Object)this.userAgent))) {
            callSiteArray[36].call((Object)client, (Object)this.userAgent);
        }
        return client;
    }

    private static KubeConfig parseConfig(String config) throws IOException {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        ObjectMapper mapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(ObjectMapper.class, callSiteArray[38].callConstructor(YAMLFactory.class)), ObjectMapper.class);
        Map configMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)mapper, (Object)config, Map.class), Map.class);
        String currentContext = ShortTypeHandling.castToString((Object)callSiteArray[40].call((Object)configMap, (Object)"current-context"));
        ArrayList contexts = (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call((Object)configMap, (Object)"contexts"), ArrayList.class);
        ArrayList clusters = (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call((Object)configMap, (Object)"clusters"), ArrayList.class);
        ArrayList users = (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call((Object)configMap, (Object)"users"), ArrayList.class);
        KubeConfig kubeConfig = (KubeConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].callConstructor(KubeConfig.class, (Object)contexts, (Object)clusters, (Object)users), KubeConfig.class);
        callSiteArray[45].call((Object)kubeConfig, (Object)currentContext);
        return kubeConfig;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != KubernetesApiClientConfig.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = KubernetesApiClientConfig.$getCallSiteArray()[46].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesApiClientConfig");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String string) {
        this.configKey = string;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public Boolean getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(Boolean bl) {
        this.serviceAccount = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "withServiceAccount";
        stringArray[1] = "withKubeConfig";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "isRegularFile";
        stringArray[4] = "toPath";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[7] = "setSslCaCert";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "readAllBytes";
        stringArray[16] = "toPath";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[19] = "setApiKey";
        stringArray[20] = "plus";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[25] = "parseConfig";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "isEmpty";
        stringArray[30] = "currentContext";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "isEmpty";
        stringArray[33] = "setContext";
        stringArray[34] = "fromConfig";
        stringArray[35] = "isEmpty";
        stringArray[36] = "setUserAgent";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "readValue";
        stringArray[40] = "get";
        stringArray[41] = "get";
        stringArray[42] = "get";
        stringArray[43] = "get";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "setContext";
        stringArray[46] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[47];
        KubernetesApiClientConfig.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesApiClientConfig.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesApiClientConfig.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

