/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import org.springframework.stereotype.Component;

@Component
public class KubernetesUnversionedArtifactConverter
extends KubernetesArtifactConverter {
    @Override
    public Artifact toArtifact(ArtifactProvider provider, KubernetesManifest manifest) {
        String type = this.getType(manifest);
        String name = manifest.getName();
        String location = manifest.getNamespace();
        return Artifact.builder().type(type).name(name).location(location).build();
    }

    @Override
    public KubernetesCoordinates toCoordinates(Artifact artifact) {
        return KubernetesCoordinates.builder().kind(this.getKind(artifact)).namespace(this.getNamespace(artifact)).name(artifact.getName()).build();
    }

    @Override
    public String getDeployedName(Artifact artifact) {
        return artifact.getName();
    }
}

