/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Moniker;

public abstract class ManifestBasedModel {
    public String getName() {
        return this.getManifest().getFullResourceName();
    }

    public String getZone() {
        return this.getManifest().getNamespace();
    }

    public String getRegion() {
        return this.getManifest().getNamespace();
    }

    public String getType() {
        return KubernetesCloudProvider.getID();
    }

    public String getCloudProvider() {
        return KubernetesCloudProvider.getID();
    }

    public String getProviderType() {
        return KubernetesCloudProvider.getID();
    }

    public Moniker getMoniker() {
        return NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(this.getAccountName()).withResource(KubernetesManifest.class).deriveMoniker((Object)this.getManifest());
    }

    public String getAccountName() {
        return this.getKey().getAccount();
    }

    public String getAccount() {
        return this.getAccountName();
    }

    protected abstract KubernetesManifest getManifest();

    protected abstract Keys.InfrastructureCacheKey getKey();
}

