/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;

public class KubernetesApiVersion {
    public static KubernetesApiVersion V1 = new KubernetesApiVersion("v1");
    public static KubernetesApiVersion EXTENSIONS_V1BETA1 = new KubernetesApiVersion("extensions/v1beta1");
    public static KubernetesApiVersion NETWORKING_K8S_IO_V1 = new KubernetesApiVersion("network.k8s.io/v1");
    public static KubernetesApiVersion APPS_V1BETA1 = new KubernetesApiVersion("apps/v1beta1");
    public static KubernetesApiVersion APPS_V1BETA2 = new KubernetesApiVersion("apps/v1beta2");
    private final String name;
    private static List<KubernetesApiVersion> values;

    protected KubernetesApiVersion(String name) {
        if (values == null) {
            values = new ArrayList<KubernetesApiVersion>();
        }
        this.name = name;
        values.add(this);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    @JsonCreator
    public static KubernetesApiVersion fromString(String name) {
        return values.stream().filter(v -> v.name.equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException("API version " + name + " is not yet supported."));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesApiVersion)) {
            return false;
        }
        KubernetesApiVersion other = (KubernetesApiVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesApiVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

