/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;

public class KubernetesKind {
    public static KubernetesKind CONFIG_MAP = new KubernetesKind("configMap", "cm");
    public static KubernetesKind CONTROLLER_REVISION = new KubernetesKind("controllerRevision");
    public static KubernetesKind DAEMON_SET = new KubernetesKind("daemonSet", "ds");
    public static KubernetesKind DEPLOYMENT = new KubernetesKind("deployment", "deploy");
    public static KubernetesKind INGRESS = new KubernetesKind("ingress", "ing");
    public static KubernetesKind POD = new KubernetesKind("pod", "po");
    public static KubernetesKind REPLICA_SET = new KubernetesKind("replicaSet", "rs");
    public static KubernetesKind NAMESPACE = new KubernetesKind("namespace", "ns");
    public static KubernetesKind NETWORK_POLICY = new KubernetesKind("networkPolicy", "netpol");
    public static KubernetesKind SECRET = new KubernetesKind("secret");
    public static KubernetesKind SERVICE = new KubernetesKind("service", "svc");
    public static KubernetesKind STATEFUL_SET = new KubernetesKind("statefulSet");
    private final String name;
    private final String alias;
    private static List<KubernetesKind> values;

    protected KubernetesKind(String name, String alias) {
        if (values == null) {
            values = new ArrayList<KubernetesKind>();
        }
        this.name = name;
        this.alias = alias;
        values.add(this);
    }

    protected KubernetesKind(String name) {
        this(name, null);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    @JsonCreator
    public static KubernetesKind fromString(String name) {
        return values.stream().filter(v -> v.name.equalsIgnoreCase(name) || v.alias != null && v.alias.equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException("Kubernetes kind '" + name + "' is not supported."));
    }
}

