/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.servergroup;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.servergroup.KubernetesResizeServerGroupDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesResizeServerGroupOperation
implements AtomicOperation<Void> {
    private final KubernetesResizeServerGroupDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private static final String OP_NAME = "RESIZE_KUBERNETES_SERVER_GROUP";

    public KubernetesResizeServerGroupOperation(KubernetesResizeServerGroupDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        KubernetesResizeServerGroupOperation.getTask().updateStatus(OP_NAME, "Starting resize operation...");
        KubernetesCoordinates coordinates = this.description.getCoordinates();
        KubernetesResizeServerGroupOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesResourceProperties properties = this.registry.get(coordinates.getKind());
        KubernetesHandler deployer = properties.getHandler();
        if (!(deployer instanceof CanResize)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support resize");
        }
        CanResize canResize = (CanResize)((Object)deployer);
        KubernetesResizeServerGroupOperation.getTask().updateStatus(OP_NAME, "Calling resize operation...");
        canResize.resize(this.credentials, coordinates.getNamespace(), coordinates.getName(), this.description.getCapacity());
        return null;
    }
}

