/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.security;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class KubernetesConfigParser
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KubernetesConfigParser() {
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Config parse(String kubeconfigFile, String context, String cluster, String user, List<String> namespaces, Boolean serviceAccount) {
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)serviceAccount)) {
                return (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callStatic(KubernetesConfigParser.class), Config.class);
            }
            return (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callStatic(KubernetesConfigParser.class, ArrayUtil.createArray((Object)kubeconfigFile, (Object)context, (Object)cluster, (Object)user, namespaces)), Config.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)serviceAccount)) {
            return KubernetesConfigParser.withServiceAccount();
        }
        return (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callStatic(KubernetesConfigParser.class, ArrayUtil.createArray((Object)kubeconfigFile, (Object)context, (Object)cluster, (Object)user, namespaces)), Config.class);
    }

    public static Config withServiceAccount() {
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        Config config = (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(Config.class), Config.class);
        boolean serviceAccountCaCertExists = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(Files.class, callSiteArray[5].call(callSiteArray[6].callConstructor(File.class, callSiteArray[7].callGetProperty(Config.class)))));
        if (!serviceAccountCaCertExists) {
            throw (Throwable)callSiteArray[10].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGetProperty(Config.class)}, new String[]{"Could not find CA cert for service account at ", ""}));
        }
        callSiteArray[8].call((Object)config, callSiteArray[9].callGetProperty(Config.class));
        try {
            String serviceTokenCandidate = ShortTypeHandling.castToString((Object)callSiteArray[12].callConstructor(String.class, callSiteArray[13].call(Files.class, callSiteArray[14].call(callSiteArray[15].callConstructor(File.class, callSiteArray[16].callGetProperty(Config.class))))));
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)serviceTokenCandidate, null)) {
                throw (Throwable)callSiteArray[24].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[25].callGetProperty(Config.class)}, new String[]{"Did not find service account token at ", ""}));
            }
            String error = "Configured service account doesn't have access. Service account may have been revoked.";
            callSiteArray[17].call((Object)config, (Object)serviceTokenCandidate);
            callSiteArray[18].call(callSiteArray[19].call((Object)config), (Object)401, callSiteArray[20].call((Object)"Unauthorized! ", (Object)error));
            callSiteArray[21].call(callSiteArray[22].call((Object)config), (Object)403, callSiteArray[23].call((Object)"Forbidden! ", (Object)error));
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[26].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[27].callGetProperty(Config.class)}, new String[]{"Could not read service account token at ", ""}), (Object)e);
        }
        return config;
    }

    public static Config withKubeConfig(String kubeconfigFile, String context, String cluster, String user, List<String> namespaces) {
        String string;
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        Object kubeConfig = callSiteArray[28].call(KubeConfigUtils.class, callSiteArray[29].callConstructor(File.class, (Object)kubeconfigFile));
        Config config = (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callConstructor(Config.class), Config.class);
        String string2 = context;
        Reference resolvedContext = new Reference((Object)ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : callSiteArray[31].callGetProperty(kubeConfig))));
        public class _withKubeConfig_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resolvedContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _withKubeConfig_closure1(Object _outerInstance, Object _thisObject, Reference resolvedContext) {
                Reference reference;
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.resolvedContext = reference = resolvedContext;
            }

            public Object doCall(NamedContext it) {
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)it), (Object)this.resolvedContext.get());
            }

            public Object call(NamedContext it) {
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)it);
            }

            public String getResolvedContext() {
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.resolvedContext.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _withKubeConfig_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _withKubeConfig_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_withKubeConfig_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _withKubeConfig_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Context currentContext = (Context)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callSafe(callSiteArray[33].call(callSiteArray[34].callGetProperty(kubeConfig), (Object)new _withKubeConfig_closure1(KubernetesConfigParser.class, KubernetesConfigParser.class, resolvedContext))), Context.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)context) && !DefaultTypeTransformation.booleanUnbox((Object)currentContext)) {
                throw (Throwable)callSiteArray[35].callConstructor(IllegalArgumentException.class, callSiteArray[36].call((Object)new GStringImpl(new Object[]{context, kubeconfigFile}, new String[]{"Context ", " was not found in ", ""})));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)context) && !DefaultTypeTransformation.booleanUnbox((Object)currentContext)) {
            throw (Throwable)callSiteArray[37].callConstructor(IllegalArgumentException.class, callSiteArray[38].call((Object)new GStringImpl(new Object[]{context, kubeconfigFile}, new String[]{"Context ", " was not found in ", ""})));
        }
        String string3 = DefaultTypeTransformation.booleanUnbox((Object)(string = user)) ? string : callSiteArray[39].callGetProperty((Object)currentContext);
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)currentContext, (String)"user");
        String string4 = cluster;
        String string5 = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : callSiteArray[40].callGetProperty((Object)currentContext);
        ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)currentContext, (String)"cluster");
        if (DefaultTypeTransformation.booleanUnbox(namespaces)) {
            Object object = callSiteArray[41].call(namespaces, (Object)0);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)currentContext, (String)"namespace");
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGetProperty((Object)currentContext))) {
            String string6 = "default";
            ScriptBytecodeAdapter.setProperty((Object)string6, null, (Object)currentContext, (String)"namespace");
        }
        Cluster currentCluster = (Cluster)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(KubeConfigUtils.class, kubeConfig, (Object)currentContext), Cluster.class);
        callSiteArray[44].call((Object)config, (Object)"v1");
        callSiteArray[45].call((Object)config, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), String[].class)), String[].class));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentCluster, null)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call(callSiteArray[47].call((Object)currentCluster), (Object)"/"))) {
                callSiteArray[48].call((Object)config, callSiteArray[49].call(callSiteArray[50].call((Object)currentCluster), (Object)"/"));
            }
            callSiteArray[51].call((Object)config, callSiteArray[52].call((Object)currentContext));
            callSiteArray[53].call((Object)config, (Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[54].call((Object)currentCluster), null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call((Object)currentCluster)) ? 1 : 0));
            callSiteArray[56].call((Object)config, callSiteArray[57].call((Object)currentCluster));
            callSiteArray[58].call((Object)config, callSiteArray[59].call((Object)currentCluster));
            AuthInfo currentAuthInfo = (AuthInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].call(KubeConfigUtils.class, kubeConfig, (Object)currentContext), AuthInfo.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)currentAuthInfo, null)) {
                callSiteArray[61].call((Object)config, callSiteArray[62].call((Object)currentAuthInfo));
                callSiteArray[63].call((Object)config, callSiteArray[64].call((Object)currentAuthInfo));
                callSiteArray[65].call((Object)config, callSiteArray[66].call((Object)currentAuthInfo));
                callSiteArray[67].call((Object)config, callSiteArray[68].call((Object)currentAuthInfo));
                callSiteArray[69].call((Object)config, callSiteArray[70].call((Object)currentAuthInfo));
                callSiteArray[71].call((Object)config, callSiteArray[72].call((Object)currentAuthInfo));
                callSiteArray[73].call((Object)config, callSiteArray[74].call((Object)currentAuthInfo));
                callSiteArray[75].call(callSiteArray[76].call((Object)config), (Object)401, (Object)"Unauthorized! Token may have expired! Please log-in again.");
                callSiteArray[77].call(callSiteArray[78].call((Object)config), (Object)403, callSiteArray[79].call((Object)new GStringImpl(new Object[]{callSiteArray[80].callGetProperty((Object)currentContext)}, new String[]{"Forbidden! User ", " doesn't have permission."})));
            }
        }
        return config;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KubernetesConfigParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "withServiceAccount";
        stringArray[1] = "withKubeConfig";
        stringArray[2] = "withKubeConfig";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "isRegularFile";
        stringArray[5] = "toPath";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[8] = "setCaCertFile";
        stringArray[9] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "readAllBytes";
        stringArray[14] = "toPath";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[17] = "setOauthToken";
        stringArray[18] = "put";
        stringArray[19] = "getErrorMessages";
        stringArray[20] = "plus";
        stringArray[21] = "put";
        stringArray[22] = "getErrorMessages";
        stringArray[23] = "plus";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[28] = "parseConfig";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "currentContext";
        stringArray[32] = "getContext";
        stringArray[33] = "find";
        stringArray[34] = "contexts";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "toString";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "toString";
        stringArray[39] = "user";
        stringArray[40] = "cluster";
        stringArray[41] = "getAt";
        stringArray[42] = "namespace";
        stringArray[43] = "getCluster";
        stringArray[44] = "setApiVersion";
        stringArray[45] = "setNoProxy";
        stringArray[46] = "endsWith";
        stringArray[47] = "getServer";
        stringArray[48] = "setMasterUrl";
        stringArray[49] = "plus";
        stringArray[50] = "getServer";
        stringArray[51] = "setNamespace";
        stringArray[52] = "getNamespace";
        stringArray[53] = "setTrustCerts";
        stringArray[54] = "getInsecureSkipTlsVerify";
        stringArray[55] = "getInsecureSkipTlsVerify";
        stringArray[56] = "setCaCertFile";
        stringArray[57] = "getCertificateAuthority";
        stringArray[58] = "setCaCertData";
        stringArray[59] = "getCertificateAuthorityData";
        stringArray[60] = "getUserAuthInfo";
        stringArray[61] = "setClientCertFile";
        stringArray[62] = "getClientCertificate";
        stringArray[63] = "setClientCertData";
        stringArray[64] = "getClientCertificateData";
        stringArray[65] = "setClientKeyFile";
        stringArray[66] = "getClientKey";
        stringArray[67] = "setClientKeyData";
        stringArray[68] = "getClientKeyData";
        stringArray[69] = "setOauthToken";
        stringArray[70] = "getToken";
        stringArray[71] = "setUsername";
        stringArray[72] = "getUsername";
        stringArray[73] = "setPassword";
        stringArray[74] = "getPassword";
        stringArray[75] = "put";
        stringArray[76] = "getErrorMessages";
        stringArray[77] = "put";
        stringArray[78] = "getErrorMessages";
        stringArray[79] = "toString";
        stringArray[80] = "user";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[81];
        KubernetesConfigParser.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesConfigParser.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesConfigParser.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

