/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Application;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.model.Application;
import com.netflix.spinnaker.clouddriver.model.ApplicationProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ApplicationProvider
implements ApplicationProvider {
    private final KubernetesCacheUtils cacheUtils;

    @Autowired
    KubernetesV2ApplicationProvider(KubernetesCacheUtils cacheUtils) {
        this.cacheUtils = cacheUtils;
    }

    public Set<? extends Application> getApplications(boolean expand) {
        if (expand) {
            String clusterGlobKey = Keys.cluster("*", "*", "*");
            Map keysByApplication = this.cacheUtils.getAllKeysMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), clusterGlobKey).stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(Keys.ClusterCacheKey.class::isInstance).map(k -> (Keys.ClusterCacheKey)k).collect(Collectors.groupingBy(Keys.ClusterCacheKey::getApplication, Collectors.toSet()));
            return keysByApplication.entrySet().stream().map(e -> KubernetesV2Application.builder().name((String)e.getKey()).clusterNames(this.groupClustersByAccount((Collection)e.getValue())).build()).collect(Collectors.toSet());
        }
        String appGlobKey = Keys.application("*");
        return this.cacheUtils.getAllKeysMatchingPattern(Keys.LogicalKind.APPLICATIONS.toString(), appGlobKey).stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(Keys.ApplicationCacheKey.class::isInstance).map(k -> (Keys.ApplicationCacheKey)k).map(k -> KubernetesV2Application.builder().name(k.getName()).build()).collect(Collectors.toSet());
    }

    public Application getApplication(String name) {
        String clusterGlobKey = Keys.cluster("*", name, "*");
        List<Keys.ClusterCacheKey> keys = this.cacheUtils.getAllKeysMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), clusterGlobKey).stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(Keys.ClusterCacheKey.class::isInstance).map(k -> (Keys.ClusterCacheKey)k).collect(Collectors.toList());
        return KubernetesV2Application.builder().name(name).clusterNames(this.groupClustersByAccount(keys)).build();
    }

    private Map<String, Set<String>> groupClustersByAccount(Collection<Keys.ClusterCacheKey> keys) {
        return keys.stream().collect(Collectors.groupingBy(Keys.ClusterCacheKey::getAccount, Collectors.mapping(Keys.ClusterCacheKey::getName, Collectors.toSet())));
    }
}

