/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelectorList;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.util.KubeConfig;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class KubernetesV2Credentials
implements KubernetesCredentials {
    private final KubectlJobExecutor jobExecutor;
    private final Registry registry;
    private final Clock clock;
    private final String accountName;
    private final ObjectMapper mapper = new ObjectMapper();
    private final List<String> namespaces;
    private final List<String> omitNamespaces;
    private final String kubeconfigFile;
    private final String context;
    @JsonIgnore
    private final String oAuthServiceAccount;
    @JsonIgnore
    private final List<String> oAuthScopes;
    private final String defaultNamespace = "default";
    private final boolean debug;

    private KubernetesV2Credentials(@NotNull String accountName, @NotNull KubectlJobExecutor jobExecutor, @NotNull List<String> namespaces, @NotNull List<String> omitNamespaces, @NotNull Registry registry, String kubeconfigFile, String context, String oAuthServiceAccount, List<String> oAuthScopes, boolean debug) {
        this.registry = registry;
        this.clock = registry.clock();
        this.accountName = accountName;
        this.namespaces = namespaces;
        this.omitNamespaces = omitNamespaces;
        this.jobExecutor = jobExecutor;
        this.debug = debug;
        this.kubeconfigFile = kubeconfigFile;
        this.context = context;
        this.oAuthServiceAccount = oAuthServiceAccount;
        this.oAuthScopes = oAuthScopes;
    }

    @Override
    public List<String> getDeclaredNamespaces() {
        List<String> result;
        if (!this.namespaces.isEmpty()) {
            result = this.namespaces;
        } else {
            try {
                List<KubernetesManifest> namespaceManifests = this.jobExecutor.list(this, KubernetesKind.NAMESPACE, "");
                result = namespaceManifests.stream().map(KubernetesManifest::getName).collect(Collectors.toList());
            }
            catch (KubectlJobExecutor.KubectlException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.omitNamespaces.isEmpty()) {
            result = result.stream().filter(n -> !this.omitNamespaces.contains(n)).collect(Collectors.toList());
        }
        return result;
    }

    public KubernetesManifest get(KubernetesKind kind, String namespace, String name) {
        return this.runAndRecordMetrics("get", kind, namespace, () -> this.jobExecutor.get(this, kind, namespace, name));
    }

    public List<KubernetesManifest> list(KubernetesKind kind, String namespace) {
        return this.runAndRecordMetrics("list", kind, namespace, () -> this.jobExecutor.list(this, kind, namespace));
    }

    public String logs(String namespace, String podName, String containerName) {
        return this.runAndRecordMetrics("logs", KubernetesKind.POD, namespace, () -> this.jobExecutor.logs(this, namespace, podName, containerName));
    }

    public void scale(KubernetesKind kind, String namespace, String name, int replicas) {
        this.runAndRecordMetrics("scale", kind, namespace, () -> this.jobExecutor.scale(this, kind, namespace, name, replicas));
    }

    public List<String> delete(KubernetesKind kind, String namespace, String name, KubernetesSelectorList labelSelectors, V1DeleteOptions options) {
        return this.runAndRecordMetrics("scale", kind, namespace, () -> this.jobExecutor.delete(this, kind, namespace, name, labelSelectors, options));
    }

    public void deploy(KubernetesManifest manifest) {
        this.runAndRecordMetrics("deploy", manifest.getKind(), manifest.getNamespace(), () -> this.jobExecutor.deploy(this, manifest));
    }

    public List<Integer> historyRollout(KubernetesKind kind, String namespace, String name) {
        return this.runAndRecordMetrics("historyRollout", kind, namespace, () -> this.jobExecutor.historyRollout(this, kind, namespace, name));
    }

    public void undoRollout(KubernetesKind kind, String namespace, String name, int revision) {
        this.runAndRecordMetrics("undoRollout", kind, namespace, () -> this.jobExecutor.undoRollout(this, kind, namespace, name, revision));
    }

    public void pauseRollout(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("pauseRollout", kind, namespace, () -> this.jobExecutor.pauseRollout(this, kind, namespace, name));
    }

    public void resumeRollout(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("resumeRollout", kind, namespace, () -> this.jobExecutor.resumeRollout(this, kind, namespace, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T runAndRecordMetrics(String action, KubernetesKind kind, String namespace, Supplier<T> op) {
        T result = null;
        Exception failure = null;
        KubectlJobExecutor.KubectlException apiException = null;
        long startTime = this.clock.monotonicTime();
        try {
            result = op.get();
        }
        catch (KubectlJobExecutor.KubectlException e) {
            apiException = e;
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("action", action);
            tags.put("kind", kind.toString());
            tags.put("account", this.accountName);
            tags.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
            if (failure == null) {
                tags.put("success", "true");
            } else {
                tags.put("success", "false");
                tags.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
            }
            this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            if (failure != null) {
                throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kind + ": " + failure.getMessage(), failure);
            }
            if (apiException != null) {
                throw apiException;
            }
            return result;
        }
        catch (Exception e2) {
            failure = e2;
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("action", action);
            {
                catch (Throwable throwable) {
                    HashMap<String, String> tags2 = new HashMap<String, String>();
                    tags2.put("action", action);
                    tags2.put("kind", kind.toString());
                    tags2.put("account", this.accountName);
                    tags2.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
                    if (failure == null) {
                        tags2.put("success", "true");
                    } else {
                        tags2.put("success", "false");
                        tags2.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
                    }
                    this.registry.timer(this.registry.createId("kubernetes.api", tags2)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
                    if (failure != null) {
                        throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kind + ": " + failure.getMessage(), failure);
                    }
                    if (apiException != null) {
                        throw apiException;
                    }
                    return result;
                }
            }
            tags.put("kind", kind.toString());
            tags.put("account", this.accountName);
            tags.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
            if (failure == null) {
                tags.put("success", "true");
            } else {
                tags.put("success", "false");
                tags.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
            }
            this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            if (failure != null) {
                throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kind + ": " + failure.getMessage(), failure);
            }
            if (apiException != null) {
                throw apiException;
            }
            return result;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("action", action);
        tags.put("kind", kind.toString());
        tags.put("account", this.accountName);
        tags.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
        if (failure == null) {
            tags.put("success", "true");
        } else {
            tags.put("success", "false");
            tags.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
        }
        this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
        if (failure != null) {
            throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kind + ": " + failure.getMessage(), failure);
        }
        if (apiException != null) {
            throw apiException;
        }
        return result;
    }

    public String getKubeconfigFile() {
        return this.kubeconfigFile;
    }

    public String getContext() {
        return this.context;
    }

    public String getOAuthServiceAccount() {
        return this.oAuthServiceAccount;
    }

    public List<String> getOAuthScopes() {
        return this.oAuthScopes;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static class Builder {
        String accountName;
        String kubeconfigFile;
        String context;
        String oAuthServiceAccount;
        List<String> oAuthScopes;
        String userAgent;
        List<String> namespaces = new ArrayList<String>();
        List<String> omitNamespaces = new ArrayList<String>();
        Registry registry;
        KubectlJobExecutor jobExecutor;
        boolean debug;

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder kubeconfigFile(String kubeconfigFile) {
            this.kubeconfigFile = kubeconfigFile;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder namespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        public Builder omitNamespaces(List<String> omitNamespaces) {
            this.omitNamespaces = omitNamespaces;
            return this;
        }

        public Builder registry(Registry registry) {
            this.registry = registry;
            return this;
        }

        public Builder jobExecutor(KubectlJobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder oAuthServiceAccount(String oAuthServiceAccount) {
            this.oAuthServiceAccount = oAuthServiceAccount;
            return this;
        }

        public Builder oAuthScopes(List<String> oAuthScopes) {
            this.oAuthScopes = oAuthScopes;
            return this;
        }

        public KubernetesV2Credentials build() {
            KubeConfig kubeconfig;
            try {
                kubeconfig = StringUtils.isEmpty((CharSequence)this.kubeconfigFile) ? KubeConfig.loadDefaultKubeConfig() : KubeConfig.loadKubeConfig((Reader)new FileReader(this.kubeconfigFile));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Unable to create credentials from kubeconfig file: " + e, e);
            }
            if (!StringUtils.isEmpty((CharSequence)this.context)) {
                kubeconfig.setContext(this.context);
            }
            this.namespaces = this.namespaces == null ? new ArrayList() : this.namespaces;
            this.omitNamespaces = this.omitNamespaces == null ? new ArrayList() : this.omitNamespaces;
            return new KubernetesV2Credentials(this.accountName, this.jobExecutor, this.namespaces, this.omitNamespaces, this.registry, this.kubeconfigFile, this.context, this.oAuthServiceAccount, this.oAuthScopes, this.debug);
        }
    }
}

