/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.validator;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;

public class KubernetesValidationUtil {
    private final String context;
    private final Errors errors;

    public KubernetesValidationUtil(String context, Errors errors) {
        this.context = context;
        this.errors = errors;
    }

    private String joinAttributeChain(String ... attributes) {
        ArrayList<String> chain = new ArrayList<String>();
        chain.add(this.context);
        Collections.addAll(chain, attributes);
        return String.join((CharSequence)".", chain);
    }

    public void reject(String errorName, String ... attributes) {
        String field = this.joinAttributeChain(attributes);
        String error = this.joinAttributeChain(field, errorName);
        this.errors.reject(field, error);
    }

    public boolean validateNotEmpty(String attribute, Object value) {
        if (value == null) {
            this.reject("empty", attribute);
            return false;
        }
        return true;
    }

    public boolean validateSizeEquals(String attribute, Collection items, int size) {
        if (items.size() != size) {
            this.reject("size!=" + size, attribute);
            return false;
        }
        return true;
    }

    public boolean validateNotEmpty(String attribute, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.reject("empty", attribute);
            return false;
        }
        return true;
    }

    public boolean validateV2Credentials(AccountCredentialsProvider provider, String accountName) {
        if (!this.validateNotEmpty("account", accountName)) {
            return false;
        }
        AccountCredentials credentials = provider.getCredentials(accountName);
        if (credentials == null) {
            this.reject("notFound", "account");
            return false;
        }
        if (!(credentials.getCredentials() instanceof KubernetesV2Credentials)) {
            this.reject("wrongVersion", "account");
            return false;
        }
        return true;
    }
}

