/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.manifest;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesUndoRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@KubernetesOperation(value="undoRolloutManifest")
@Component
public class KubernetesUndoRolloutManifestValidator
extends DescriptionValidator<KubernetesUndoRolloutManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List priorDescriptions, KubernetesUndoRolloutManifestDescription description, Errors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("undoRolloutKubernetesManifest", errors);
        if (!util.validateV2Credentials(this.provider, description.getAccount())) {
            return;
        }
        if (description.getNumRevisionsBack() == null && description.getRevision() == null) {
            util.reject("empty", "numRevisionsBack & revision");
        }
    }

    public boolean acceptsVersion(ProviderVersion version) {
        return version == ProviderVersion.v2;
    }
}

