/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BERSet;
import cfca.sadk.org.bouncycastle.asn1.DERInteger;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DERObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.signature.sm2.SM2SignerInfo;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;

public class PKCS7SignedData {
    private Session session = null;
    private SignedData signedData = null;
    static final String pkcs_7 = "1.2.840.113549.1.7";
    public static final String DATA = new DERObjectIdentifier("1.2.840.113549.1.7.1").getId();
    public static final String SIGNED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.2").getId();
    public static final String ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.3").getId();
    public static final String SIGNED_ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.4").getId();
    public static final String DIGESTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.5").getId();
    public static final String ENCRYPTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.6").getId();

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public byte[] packageSM2SignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptedData, X509Cert[] certs) throws Exception {
        SM2SignerInfo signerInfo;
        if (certs == null) {
            throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
        }
        if (encryptedData == null || encryptedData.length != 64) {
            throw new Exception("the encrypt data is null or not 64 bytes!");
        }
        byte[] r = null;
        byte[] s = null;
        if ((encryptedData[0] & 0x80) != 0) {
            r = new byte[33];
            r[0] = 0;
            System.arraycopy(encryptedData, 0, r, 1, 32);
        } else {
            r = new byte[32];
            System.arraycopy(encryptedData, 0, r, 0, 32);
        }
        if ((encryptedData[32] & 0x80) != 0) {
            s = new byte[33];
            s[0] = 0;
            System.arraycopy(encryptedData, 32, s, 1, 32);
        } else {
            s = new byte[32];
            System.arraycopy(encryptedData, 32, s, 0, 32);
        }
        DERInteger derR = new DERInteger(r);
        DERInteger derS = new DERInteger(s);
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        AlgorithmIdentifier digestEncryptAlgIdentifier = null;
        AlgorithmIdentifier digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, new DERNull());
        if (SM2ContextConfig.getSignFormat() == 3) {
            digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, new DERNull());
            signerInfo = new SM2SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
        } else if (SM2ContextConfig.getSignFormat() == 2) {
            digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm2Encryption, new DERNull());
            signerInfo = new SM2SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
        } else {
            digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm2Encryption, new DERNull());
            signerInfo = new SM2SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
        }
        ContentInfo contentInfo = null;
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.sm2Data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
        } else {
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.sm2Data, null) : new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgIdentifier);
        DERSet digestAlgorithmSets = new DERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(new ASN1Integer(1L), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.sm2SignedData, signedData);
        return ASN1Parser.parseDERObj2Bytes(contentInfoTemp);
    }

    public byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
            }
            if (CertUtil.isSM2Cert(certs[0])) {
                return this.packageSM2SignedData(ifAttach, contentType, sourceData, encryptData, certs);
            }
            return this.packageRSASignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, certs);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public void loadDERData(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void loadBase64(byte[] data) throws PKIException {
        if (ASN1Parser.isBase64Compatability(data)) {
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    private void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        SignedData sd = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.PARSE_P7_SIGNEDDATA_ERR_DES, ex);
        }
        this.signedData = sd;
    }

    public boolean verifyP7SignedDataAttach() throws PKIException {
        byte[] sourceData = this.getSourceData();
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, null, aset, null);
        }
        return this.verifyRSASignerInfo((byte[])sourceData.clone(), aset, null);
    }

    public byte[] getSourceData() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.sm2Data)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = ASN1Parser.parseDERObj2Bytes(contentInfo.getContent().toASN1Primitive());
        }
        return (byte[])sourceData.clone();
    }

    private boolean verifySignerInfoByFile(InputStream sourceFileStream, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("md5WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("sha1WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("sha256WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("sha512WithRSAEncryption");
                } else {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                return this.session.verify(signM, pubKey, sourceFileStream, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifyRSASignerInfo(byte[] content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("md5WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("sha1WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("sha256WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("sha512WithRSAEncryption");
                } else {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] bAuthAttries = ASN1Parser.parseDERObj2Bytes(authAttributes);
                    return this.session.verify(signM, pubKey, bAuthAttries, signature);
                }
                return this.session.verify(signM, pubKey, content, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifySM2SignerInfoByFile(InputStream sourceFileStream, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                return this.session.verify(new Mechanism("sm3WithSM2Encryption"), pubKey, sourceFileStream, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_SM2_SIGNEDDATA_ERR, PKIException.VERIFY_SM2_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifySM2SignerInfo(byte[] content, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] bAuthAttries = ASN1Parser.parseDERObj2Bytes(authAttributes);
                    return this.session.verify(new Mechanism("sm3WithSM2Encryption"), pubKey, bAuthAttries, signature);
                }
                return this.session.verify(new Mechanism("sm3WithSM2Encryption"), pubKey, content, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_SM2_SIGNEDDATA_ERR, PKIException.VERIFY_SM2_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean isSM2Cert() {
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        return CertUtil.isSM2Cert(new X509Cert(certStru));
    }

    private X509Cert[] getSignerCerts() throws PKIException {
        ASN1Set certSet = this.signedData.getCertificates();
        X509Cert[] signerCerts = new X509Cert[certSet.size()];
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
            signerCerts[i] = new X509Cert(certStru);
        }
        return signerCerts;
    }

    public X509Cert getSignerX509Cert() throws PKIException {
        X509Cert signerCerts = null;
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        signerCerts = new X509Cert(certStru);
        return signerCerts;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    private X509Cert getSM2SignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public boolean verifyP7SignedData(InputStream sourceFileStream) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfoByFile(sourceFileStream, true, null, aset, null);
        }
        return this.verifySignerInfoByFile(sourceFileStream, aset, null);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo(sourceData, true, null, aset, null);
        }
        return this.verifyRSASignerInfo(sourceData, aset, null);
    }

    private byte[] getSM2Signature() throws PKIException {
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
            byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
            byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
            byte[] signature = new byte[64];
            System.arraycopy(r, 0, signature, 0, 32);
            System.arraycopy(s, 0, signature, 32, 32);
            return signature;
        }
        throw new PKIException("can not get SM2SignerInfo object!!!");
    }

    public byte[] getSignature() throws PKIException {
        if (this.isSM2Cert()) {
            return this.getSM2Signature();
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            return signerInfo.getEncryptedDigest().getOctets();
        }
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public String getDigestAlgorithm() throws PKIException {
        if (this.isSM2Cert()) {
            return "SM3";
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        String signM = null;
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
            if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                signM = "MD5";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                signM = "SHA-1";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                signM = "SHA-256";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                signM = "SHA-512";
            } else {
                throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
            }
            return signM;
        }
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public boolean verifySM2SignedData(InputStream sourceStream, boolean ifZValue, byte[] userId) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                return this.verifySM2SignerInfoByFile(sourceStream, true, (byte[])userId.clone(), aset, null);
            }
            return this.verifySM2SignerInfoByFile(sourceStream, true, null, aset, null);
        }
        return this.verifySM2SignerInfoByFile(sourceStream, false, null, aset, null);
    }

    public boolean verifySM2SignedData(byte[] sourceData, boolean ifZValue, byte[] userId) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, (byte[])userId.clone(), aset, null);
            }
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, null, aset, null);
        }
        return this.verifySM2SignerInfo((byte[])sourceData.clone(), false, null, aset, null);
    }

    public byte[] packageRSASignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (certs == null) {
            throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
        }
        DEROctetString encryptedData = new DEROctetString(encryptData);
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        AlgorithmIdentifier digestAlgIdentifier = null;
        String digestAlgorithm = mechanism.getMechanismType();
        if (digestAlgorithm.equals("MD5") || digestAlgorithm.equals("md5WithRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
        } else if (digestAlgorithm.equals("SHA-1") || digestAlgorithm.equals("sha1WithRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
        } else if (digestAlgorithm.equals("SHA-256") || digestAlgorithm.equals("sha256WithRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, new DERNull());
        } else if (digestAlgorithm.equals("SHA-512") || digestAlgorithm.equals("sha512WithRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, new DERNull());
        }
        SignerInfo signerInfo = new SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
        ContentInfo contentInfo = null;
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
        } else {
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, null) : new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgIdentifier);
        BERSet digestAlgorithmSets = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(new ASN1Integer(1L), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return ASN1Parser.parseDERObj2Bytes(contentInfoTemp);
    }

    public boolean verifyP7SignedDataByHash(byte[] digest) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfoByHash(digest, aset, null);
        }
        return this.verifySignerInfoByHash(digest, aset, null);
    }

    private boolean verifySignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("md5WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("sha1WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("sha256WithRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("sha512WithRSAEncryption");
                } else {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                return this.session.verifyByHash(signM, pubKey, digest, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifySM2SignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                return this.session.verifyByHash(new Mechanism("sm3WithSM2Encryption"), pubKey, digest, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_SM2_SIGNEDDATA_ERR, PKIException.VERIFY_SM2_SIGNEDDATA_ERR_DES, ex);
        }
    }
}

