/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.sm2;

import cfca.sadk.algorithm.sm2.SM2Param;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import java.math.BigInteger;
import java.security.PrivateKey;

public class SM2PrivateKey
implements PrivateKey {
    private SM2PublicKey pubKey = null;
    private ECPrivateKeyParameters priParam = null;
    private static final long serialVersionUID = 1L;

    public String toString() {
        String sm2PriKeyMark = "SM2 Private Key";
        String D = this.priParam.getD().toString();
        String lineSeparator = System.getProperty("line.separator");
        String sm2PriMsg = sm2PriKeyMark + ":" + lineSeparator + "D:" + D + lineSeparator + "X:" + this.pubKey.getPubXByInt() + lineSeparator + "Y:" + this.pubKey.getPubYByInt();
        return sm2PriMsg;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        X962Parameters params = new X962Parameters(DERNull.INSTANCE);
        PrivateKeyInfo info = null;
        ECPrivateKey keyStructure = new ECPrivateKey(this.getDByInt(), params);
        try {
            info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), keyStructure);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            return null;
        }
    }

    public SM2PrivateKey(ECPrivateKeyParameters priParam) {
        this.priParam = priParam;
    }

    public SM2PrivateKey(byte[] da, byte[] pubX, byte[] pubY) {
        this.constructSM2PrivateKey(da, pubX, pubY);
    }

    private void constructSM2PrivateKey(byte[] da, byte[] pubX, byte[] pubY) {
        BigInteger d = new BigInteger(1, da);
        this.priParam = new ECPrivateKeyParameters(d, SM2Param.ecc_bc_spec);
        if (pubX != null && pubY != null) {
            this.pubKey = new SM2PublicKey(pubX, pubY);
        }
    }

    public BigInteger getDByInt() {
        return this.priParam.getD();
    }

    public byte[] getDByBytes() {
        return BigIntegerUtil.asUnsigned32ByteArray(this.priParam.getD());
    }

    public byte[] getDByBytesWithPublicKey() {
        byte[] temp = null;
        if (this.pubKey != null) {
            temp = new byte[96];
            System.arraycopy(this.getDByBytes(), 0, temp, 0, 32);
            System.arraycopy(this.pubKey.getPubXByBytes(), 0, temp, 32, 32);
            System.arraycopy(this.pubKey.getPubYByBytes(), 0, temp, 64, 32);
        } else {
            temp = new byte[32];
            System.arraycopy(this.getDByBytes(), 0, temp, 0, 32);
        }
        return temp;
    }

    public static SM2PrivateKey getInstance(byte[] keyByteData) {
        if (keyByteData == null || keyByteData.length != 32 && keyByteData.length != 96) {
            return null;
        }
        byte[] da = new byte[32];
        byte[] pubX = null;
        byte[] pubY = null;
        System.arraycopy(keyByteData, 0, da, 0, 32);
        if (keyByteData.length != 32) {
            pubX = new byte[32];
            pubY = new byte[32];
            System.arraycopy(keyByteData, 32, pubX, 0, 32);
            System.arraycopy(keyByteData, 64, pubY, 0, 32);
        }
        return new SM2PrivateKey(da, pubX, pubY);
    }

    public void setSM2PublicKey(SM2PublicKey pubKey) {
        this.pubKey = pubKey;
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.pubKey;
    }
}

