/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.util.Hashtable;

public class AttributeTableUnitTest
extends SimpleTest {
    private static final ASN1ObjectIdentifier type1 = new ASN1ObjectIdentifier("1.1.1");
    private static final ASN1ObjectIdentifier type2 = new ASN1ObjectIdentifier("1.1.2");
    private static final ASN1ObjectIdentifier type3 = new ASN1ObjectIdentifier("1.1.3");

    public String getName() {
        return "AttributeTable";
    }

    public void performTest() throws Exception {
        Hashtable t;
        ASN1EncodableVector vec;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new Attribute(type1, new DERSet(type1)));
        v.add(new Attribute(type2, new DERSet(type2)));
        AttributeTable table = new AttributeTable(v);
        Attribute a = table.get(type1);
        if (a == null) {
            this.fail("type1 attribute not found.");
        }
        if (!a.getAttrValues().equals(new DERSet(type1))) {
            this.fail("wrong value retrieved for type1!");
        }
        if ((a = table.get(type2)) == null) {
            this.fail("type2 attribute not found.");
        }
        if (!a.getAttrValues().equals(new DERSet(type2))) {
            this.fail("wrong value retrieved for type2!");
        }
        if ((a = table.get(type3)) != null) {
            this.fail("type3 attribute found when none expected.");
        }
        if ((vec = table.getAll(type1)).size() != 1) {
            this.fail("wrong vector size for type1.");
        }
        if ((vec = table.getAll(type3)).size() != 0) {
            this.fail("wrong vector size for type3.");
        }
        if ((vec = table.toASN1EncodableVector()).size() != 2) {
            this.fail("wrong vector size for single.");
        }
        if ((t = table.toHashtable()).size() != 2) {
            this.fail("hashtable wrong size.");
        }
        v = new ASN1EncodableVector();
        v.add(new Attribute(type1, new DERSet(type1)));
        v.add(new Attribute(type1, new DERSet(type2)));
        v.add(new Attribute(type1, new DERSet(type3)));
        v.add(new Attribute(type2, new DERSet(type2)));
        table = new AttributeTable(v);
        a = table.get(type1);
        if (!a.getAttrValues().equals(new DERSet(type1))) {
            this.fail("wrong value retrieved for type1 multi get!");
        }
        if ((vec = table.getAll(type1)).size() != 3) {
            this.fail("wrong vector size for multiple type1.");
        }
        if (!(a = (Attribute)vec.get(0)).getAttrValues().equals(new DERSet(type1))) {
            this.fail("wrong value retrieved for type1(0)!");
        }
        if (!(a = (Attribute)vec.get(1)).getAttrValues().equals(new DERSet(type2))) {
            this.fail("wrong value retrieved for type1(1)!");
        }
        if (!(a = (Attribute)vec.get(2)).getAttrValues().equals(new DERSet(type3))) {
            this.fail("wrong value retrieved for type1(2)!");
        }
        if ((vec = table.getAll(type2)).size() != 1) {
            this.fail("wrong vector size for multiple type2.");
        }
        if ((vec = table.toASN1EncodableVector()).size() != 4) {
            this.fail("wrong vector size for multiple.");
        }
    }

    public static void main(String[] args) {
        AttributeTableUnitTest.runTest(new AttributeTableUnitTest());
    }
}

