/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.icao.CscaMasterList;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.io.Streams;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class CscaMasterListTest
extends SimpleTest {
    public String getName() {
        return "CscaMasterList";
    }

    public void performTest() throws Exception {
        byte[] output;
        byte[] input = this.getInput("masterlist-content.data");
        CscaMasterList parsedList = CscaMasterList.getInstance(ASN1Primitive.fromByteArray(input));
        if (parsedList.getCertStructs().length != 3) {
            this.fail("Cert structure parsing failed: incorrect length");
        }
        if (!Arrays.areEqual(input, output = parsedList.getEncoded())) {
            this.fail("Encoding failed after parse");
        }
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll(this.getClass().getResourceAsStream(name));
    }

    public static void main(String[] args) {
        CscaMasterListTest.runTest(new CscaMasterListTest());
    }
}

