/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1String;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.style.RFC4519Style;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Attribute;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralNames;
import cfca.sadk.org.bouncycastle.cert.AttributeCertificateHolder;
import cfca.sadk.org.bouncycastle.cert.AttributeCertificateIssuer;
import cfca.sadk.org.bouncycastle.cert.X509AttributeCertificateHolder;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.X509v2AttributeCertificateBuilder;
import cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import cfca.sadk.org.bouncycastle.operator.ContentSigner;
import cfca.sadk.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cfca.sadk.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import cfca.sadk.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import cfca.sadk.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import cfca.sadk.org.bouncycastle.util.CollectionStore;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import junit.framework.TestCase;

public class BcAttrCertTest
extends TestCase {
    DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
    DefaultDigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    private static final AsymmetricKeyParameter RSA_PRIVATE_KEY_SPEC = new RSAPrivateCrtKeyParameters(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
    public static byte[] attrCert = Base64.decode("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");
    byte[] signCert = Base64.decode("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");
    static byte[] certWithBaseCertificateID = Base64.decode("MIIBqzCCARQCAQEwSKBGMD6kPDA6MQswCQYDVQQGEwJJVDEOMAwGA1UEChMFVU5JVE4xDDAKBgNVBAsTA0RJVDENMAsGA1UEAxMEcm9vdAIEAVMVjqB6MHikdjB0MQswCQYDVQQGEwJBVTEoMCYGA1UEChMfVGhlIExlZ2lvbiBvZiB0aGUgQm91bmN5IENhc3RsZTEjMCEGA1UECxMaQm91bmN5IFByaW1hcnkgQ2VydGlmaWNhdGUxFjAUBgNVBAMTDUJvdW5jeSBDYXN0bGUwDQYJKoZIhvcNAQEFBQACBQKWRhnHMCIYDzIwMDUxMjEyMTIwMDQyWhgPMjAwNTEyMTkxMjAxMzJaMA8wDQYDVRhIMQaBBGVWSVAwDQYJKoZIhvcNAQEFBQADgYEAUAVin9StDaA+InxtXq/av6rUQLI9p1X6louBcj4kYJnxRvTrHpsrN3+i9Uq/uk5lRdAqmPFvcmSbuE3TRAsjrXON5uFiBBKZ1AouLqcr8nHbwcdwjJ9TyUNO9I4hfpSHUHHXMtBKgp4MOkhhX8xTGyWg3hp23d3GaUeg/IYlXBI=");
    byte[] holderCertWithBaseCertificateID = Base64.decode("MIIBwDCCASmgAwIBAgIEAVMVjjANBgkqhkiG9w0BAQUFADA6MQswCQYDVQQGEwJJVDEOMAwGA1UEChMFVU5JVE4xDDAKBgNVBAsTA0RJVDENMAsGA1UEAxMEcm9vdDAeFw0wNTExMTExMjAxMzJaFw0wNjA2MTYxMjAxMzJaMD4xCzAJBgNVBAYTAklUMQ4wDAYDVQQKEwVVTklUTjEMMAoGA1UECxMDRElUMREwDwYDVQQDEwhMdWNhQm9yejBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERoxUwEzARBglghkgBhvhCAQEEBAMCBDAwDQYJKoZIhvcNAQEFBQADgYEAsX50VPQQCWmHvPq9y9DeCpmS4szcpFAhpZyn6gYRwY9CRZVtmZKH8713XhkGDWcIEMcG0u3oTz3tdKgPU5uyIPrDEWr6w8ClUj4x5aVz5c2223+dVY7KES//JSB2bE/KCIchN3kAioQ4K8O3e0OL6oDVjsqKGw5bfahgKuSIk/Q=");

    public String getName() {
        return "AttrCertTest";
    }

    public void testCertWithBaseCertificateID() throws Exception {
        X509AttributeCertificateHolder attrCert = new X509AttributeCertificateHolder(certWithBaseCertificateID);
        X509CertificateHolder cert = new X509CertificateHolder(this.holderCertWithBaseCertificateID);
        AttributeCertificateHolder holder = attrCert.getHolder();
        if (holder.getEntityNames() != null) {
            BcAttrCertTest.fail((String)"entity names set when none expected");
        }
        if (!holder.getSerialNumber().equals(cert.getSerialNumber())) {
            BcAttrCertTest.fail((String)"holder serial number doesn't match");
        }
        if (!holder.getIssuer()[0].equals(cert.getIssuer())) {
            BcAttrCertTest.fail((String)"holder issuer doesn't match");
        }
        if (!holder.match(cert)) {
            BcAttrCertTest.fail((String)"holder not matching holder certificate");
        }
        if (!holder.equals(holder.clone())) {
            BcAttrCertTest.fail((String)"holder clone test failed");
        }
        if (!attrCert.getIssuer().equals(attrCert.getIssuer().clone())) {
            BcAttrCertTest.fail((String)"issuer clone test failed");
        }
    }

    private void equalityAndHashCodeTest(X509AttributeCertificateHolder attrCert, byte[] encoding) throws IOException {
        X509AttributeCertificateHolder attrCert2;
        if (!attrCert.equals(attrCert)) {
            BcAttrCertTest.fail((String)"same certificate not equal");
        }
        if (!attrCert.getHolder().equals(attrCert.getHolder())) {
            BcAttrCertTest.fail((String)"same holder not equal");
        }
        if (!attrCert.getIssuer().equals(attrCert.getIssuer())) {
            BcAttrCertTest.fail((String)"same issuer not equal");
        }
        if (attrCert.getHolder().equals(attrCert.getIssuer())) {
            BcAttrCertTest.fail((String)"wrong holder equal");
        }
        if (attrCert.getIssuer().equals(attrCert.getHolder())) {
            BcAttrCertTest.fail((String)"wrong issuer equal");
        }
        if ((attrCert2 = new X509AttributeCertificateHolder(encoding)).getHolder().hashCode() != attrCert.getHolder().hashCode()) {
            BcAttrCertTest.fail((String)"holder hashCode test failed");
        }
        if (!attrCert2.getHolder().equals(attrCert.getHolder())) {
            BcAttrCertTest.fail((String)"holder equals test failed");
        }
        if (attrCert2.getIssuer().hashCode() != attrCert.getIssuer().hashCode()) {
            BcAttrCertTest.fail((String)"issuer hashCode test failed");
        }
        if (!attrCert2.getIssuer().equals(attrCert.getIssuer())) {
            BcAttrCertTest.fail((String)"issuer equals test failed");
        }
    }

    public void testGenerateWithCert() throws Exception {
        X509CertificateHolder sCert;
        ASN1Encodable[] values;
        GeneralName role;
        Attribute attr;
        Attribute[] attrs;
        AttributeCertificateHolder holder;
        X509CertificateHolder iCert = new X509CertificateHolder(this.signCert);
        RSAKeyParameters pubKey = new RSAKeyParameters(false, new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        AsymmetricKeyParameter privKey = RSA_PRIVATE_KEY_SPEC;
        X509v2AttributeCertificateBuilder gen = new X509v2AttributeCertificateBuilder(new AttributeCertificateHolder(iCert), new AttributeCertificateIssuer(new X500Name("cn=test")), BigInteger.ONE, new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L));
        GeneralName roleName = new GeneralName(1, "DAU123456789");
        ASN1EncodableVector roleSyntax = new ASN1EncodableVector();
        roleSyntax.add(roleName);
        gen.addAttribute(new ASN1ObjectIdentifier("2.5.24.72"), new DERSequence(roleSyntax));
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA1withRSA");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlg, digAlg).build(privKey);
        X509AttributeCertificateHolder aCert = gen.build(sigGen);
        if (!aCert.isValidOn(new Date())) {
            BcAttrCertTest.fail((String)"certificate invalid");
        }
        if (!aCert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey))) {
            BcAttrCertTest.fail((String)"certificate signature not valid");
        }
        if ((holder = aCert.getHolder()).getEntityNames() != null) {
            BcAttrCertTest.fail((String)"entity names set when none expected");
        }
        if (!holder.getSerialNumber().equals(iCert.getSerialNumber())) {
            BcAttrCertTest.fail((String)"holder serial number doesn't match");
        }
        if (!holder.getIssuer()[0].equals(iCert.getIssuer())) {
            BcAttrCertTest.fail((String)"holder issuer doesn't match");
        }
        if (!holder.match(iCert)) {
            BcAttrCertTest.fail((String)"generated holder not matching holder certificate");
        }
        if ((attrs = aCert.getAttributes(new ASN1ObjectIdentifier("2.5.24.72"))) == null) {
            BcAttrCertTest.fail((String)"attributes related to 2.5.24.72 not found");
        }
        if (!(attr = attrs[0]).getAttrType().getId().equals("2.5.24.72")) {
            BcAttrCertTest.fail((String)"attribute oid mismatch");
        }
        if ((role = GeneralNames.getInstance((values = attr.getAttrValues().toArray())[0]).getNames()[0]).getTagNo() != 1) {
            BcAttrCertTest.fail((String)"wrong general name type found in role");
        }
        if (!((ASN1String)((Object)role.getName())).getString().equals("DAU123456789")) {
            BcAttrCertTest.fail((String)"wrong general name value found in role");
        }
        if (holder.match(sCert = new X509CertificateHolder(this.holderCertWithBaseCertificateID))) {
            BcAttrCertTest.fail((String)"generated holder matching wrong certificate");
        }
        this.equalityAndHashCodeTest(aCert, aCert.getEncoded());
    }

    public void testGenerateWithPrincipal() throws Exception {
        X509CertificateHolder sCert;
        AttributeCertificateHolder holder;
        X509CertificateHolder iCert = new X509CertificateHolder(this.signCert);
        RSAKeyParameters pubKey = new RSAKeyParameters(false, new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        AsymmetricKeyParameter privKey = RSA_PRIVATE_KEY_SPEC;
        X509v2AttributeCertificateBuilder gen = new X509v2AttributeCertificateBuilder(new AttributeCertificateHolder(iCert.getSubject()), new AttributeCertificateIssuer(new X500Name("cn=test")), BigInteger.ONE, new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L));
        GeneralName roleName = new GeneralName(1, "DAU123456789");
        ASN1EncodableVector roleSyntax = new ASN1EncodableVector();
        roleSyntax.add(roleName);
        gen.addAttribute(new ASN1ObjectIdentifier("2.5.24.72"), new DERSequence(roleSyntax));
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA1withRSA");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlg, digAlg).build(privKey);
        X509AttributeCertificateHolder aCert = gen.build(sigGen);
        if (!aCert.isValidOn(new Date())) {
            BcAttrCertTest.fail((String)"certificate invalid");
        }
        if (!aCert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey))) {
            BcAttrCertTest.fail((String)"certificate signature not valid");
        }
        if ((holder = aCert.getHolder()).getEntityNames() == null) {
            BcAttrCertTest.fail((String)"entity names not set when expected");
        }
        if (holder.getSerialNumber() != null) {
            BcAttrCertTest.fail((String)"holder serial number found when none expected");
        }
        if (holder.getIssuer() != null) {
            BcAttrCertTest.fail((String)"holder issuer found when none expected");
        }
        if (!holder.match(iCert)) {
            BcAttrCertTest.fail((String)"generated holder not matching holder certificate");
        }
        if (holder.match(sCert = new X509CertificateHolder(this.holderCertWithBaseCertificateID))) {
            BcAttrCertTest.fail((String)"principal generated holder matching wrong certificate");
        }
        this.equalityAndHashCodeTest(aCert, aCert.getEncoded());
    }

    public void testFully() throws Exception {
        Extension ext;
        ASN1Encodable extValue;
        X500Name principal0;
        Attribute[] attrs;
        X509AttributeCertificateHolder aCert = new X509AttributeCertificateHolder(attrCert);
        X509CertificateHolder sCert = new X509CertificateHolder(this.signCert);
        if (!aCert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(sCert))) {
            BcAttrCertTest.fail((String)"certificate signature not valid");
        }
        ArrayList<X509CertificateHolder> list = new ArrayList<X509CertificateHolder>();
        list.add(sCert);
        CollectionStore store = new CollectionStore(list);
        Collection certs = store.getMatches(aCert.getIssuer());
        if (certs.size() != 1 || !certs.contains(sCert)) {
            BcAttrCertTest.fail((String)"sCert not found by issuer");
        }
        if ((attrs = aCert.getAttributes(new ASN1ObjectIdentifier("1.3.6.1.4.1.6760.8.1.1"))) == null || attrs.length != 1) {
            BcAttrCertTest.fail((String)"attribute not found");
        }
        if (!(aCert = new X509AttributeCertificateHolder(aCert.getEncoded())).isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(sCert))) {
            BcAttrCertTest.fail((String)"certificate signature not valid");
        }
        X509AttributeCertificateHolder saCert = new X509AttributeCertificateHolder(aCert.getEncoded());
        if (!aCert.getNotAfter().equals(saCert.getNotAfter())) {
            BcAttrCertTest.fail((String)"failed date comparison");
        }
        RSAKeyParameters pubKey = new RSAKeyParameters(false, new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        AsymmetricKeyParameter privKey = RSA_PRIVATE_KEY_SPEC;
        X509v2AttributeCertificateBuilder gen = new X509v2AttributeCertificateBuilder(aCert.getHolder(), aCert.getIssuer(), aCert.getSerialNumber(), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L));
        gen.addAttribute(attrs[0].getAttrType(), attrs[0].getAttributeValues());
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA1withRSA");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlg, digAlg).build(privKey);
        aCert = gen.build(sigGen);
        if (!aCert.isValidOn(new Date())) {
            BcAttrCertTest.fail((String)"certificate not valid");
        }
        if (!aCert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey))) {
            BcAttrCertTest.fail((String)"signature not valid");
        }
        if ((certs = store.getMatches(aCert.getIssuer())).size() != 1 || !certs.contains(sCert)) {
            BcAttrCertTest.fail((String)"sCert not found by issuer");
        }
        if ((attrs = aCert.getAttributes(new ASN1ObjectIdentifier("1.3.6.1.4.1.6760.8.1.1"))) == null || attrs.length != 1) {
            BcAttrCertTest.fail((String)"attribute not found");
        }
        if (!(aCert = new X509AttributeCertificateHolder(aCert.getEncoded())).isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey))) {
            BcAttrCertTest.fail((String)"signature not valid");
        }
        AttributeCertificateIssuer issuer = aCert.getIssuer();
        X500Name[] principals = issuer.getNames();
        AttributeCertificateHolder holder = aCert.getHolder();
        if (holder.getEntityNames() == null) {
            BcAttrCertTest.fail((String)"entity names not set");
        }
        if (holder.getSerialNumber() != null) {
            BcAttrCertTest.fail((String)"holder serial number set when none expected");
        }
        if (holder.getIssuer() != null) {
            BcAttrCertTest.fail((String)"holder issuer set when none expected");
        }
        if (!(principal0 = new X500Name(RFC4519Style.INSTANCE, (principals = holder.getEntityNames())[0])).toString().equals("c=US,o=vt,ou=Class 2,ou=Virginia Tech User,cn=Markus Lorch (mlorch),1.2.840.113549.1.9.1=mlorch@vt.edu")) {
            System.err.println(principal0.toString());
            BcAttrCertTest.fail((String)"principal[0] for entity names don't match");
        }
        if (aCert.hasExtensions()) {
            BcAttrCertTest.fail((String)"hasExtensions true with no extensions");
        }
        gen.addExtension(new ASN1ObjectIdentifier("1.1"), true, new DEROctetString(new byte[10]));
        gen.addExtension(new ASN1ObjectIdentifier("2.2"), false, new DEROctetString(new byte[20]));
        aCert = gen.build(sigGen);
        Set exts = aCert.getCriticalExtensionOIDs();
        if (exts.size() != 1 || !exts.contains(new ASN1ObjectIdentifier("1.1"))) {
            BcAttrCertTest.fail((String)"critical extension test failed");
        }
        if ((exts = aCert.getNonCriticalExtensionOIDs()).size() != 1 || !exts.contains(new ASN1ObjectIdentifier("2.2"))) {
            BcAttrCertTest.fail((String)"non-critical extension test failed");
        }
        if (aCert.getCriticalExtensionOIDs().isEmpty()) {
            BcAttrCertTest.fail((String)"critical extensions not found");
        }
        if (!(extValue = (ext = aCert.getExtension(new ASN1ObjectIdentifier("1.1"))).getParsedValue()).equals(new DEROctetString(new byte[10]))) {
            BcAttrCertTest.fail((String)"wrong extension value found for 1.1");
        }
    }
}

