/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.test;

import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import cfca.sadk.org.bouncycastle.cert.selector.jcajce.JcaSelectorConverter;
import cfca.sadk.org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import cfca.sadk.org.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.cert.X509CertSelector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ConverterTest
extends TestCase {
    public void testCertificateSelectorConversion() throws Exception {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        JcaSelectorConverter toSelector = new JcaSelectorConverter();
        X509CertificateHolderSelector sid1 = new X509CertificateHolderSelector(new X500Name("CN=Test"), BigInteger.valueOf(1L), new byte[20]);
        X509CertSelector conv = converter.getCertSelector(sid1);
        ConverterTest.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        ConverterTest.assertTrue((boolean)Arrays.areEqual(conv.getSubjectKeyIdentifier(), new DEROctetString(new byte[20]).getEncoded()));
        ConverterTest.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        X509CertificateHolderSelector sid2 = toSelector.getCertificateHolderSelector(conv);
        ConverterTest.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new X509CertificateHolderSelector(new X500Name("CN=Test"), BigInteger.valueOf(1L));
        conv = converter.getCertSelector(sid1);
        ConverterTest.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        ConverterTest.assertNull((Object)conv.getSubjectKeyIdentifier());
        ConverterTest.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        sid2 = toSelector.getCertificateHolderSelector(conv);
        ConverterTest.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new X509CertificateHolderSelector(new byte[20]);
        conv = converter.getCertSelector(sid1);
        ConverterTest.assertNull((Object)conv.getIssuerAsString());
        ConverterTest.assertTrue((boolean)Arrays.areEqual(conv.getSubjectKeyIdentifier(), new DEROctetString(new byte[20]).getEncoded()));
        ConverterTest.assertNull((Object)conv.getSerialNumber());
        sid2 = toSelector.getCertificateHolderSelector(conv);
        ConverterTest.assertEquals((Object)sid1, (Object)sid2);
    }

    public static Test suite() {
        return new TestSuite(ConverterTest.class);
    }
}

