/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSAlgorithm;
import cfca.sadk.org.bouncycastle.cms.CMSAuthenticatedDataParser;
import cfca.sadk.org.bouncycastle.cms.CMSAuthenticatedDataStreamGenerator;
import cfca.sadk.org.bouncycastle.cms.OriginatorInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.RecipientInformation;
import cfca.sadk.org.bouncycastle.cms.RecipientInformationStore;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestSetup;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestUtil;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NewAuthenticatedDataStreamTest
extends TestCase {
    private static final String BC = "BC";
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _origEcKP;
    private static KeyPair _reciEcKP;
    private static X509Certificate _reciEcCert;
    private static boolean _initialised;
    public boolean DEBUG = true;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            Security.addProvider(new BouncyCastleProvider());
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _origEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcCert = CMSTestUtil.makeCertificate(_reciEcKP, _reciDN, _signKP, _signDN);
        }
    }

    public void setUp() throws Exception {
        NewAuthenticatedDataStreamTest.init();
    }

    public NewAuthenticatedDataStreamTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)NewAuthenticatedDataStreamTest.class);
    }

    public static Test suite() throws Exception {
        NewAuthenticatedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(NewAuthenticatedDataStreamTest.class));
    }

    public void testKeyTransDESede() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.DES_EDE3_CBC);
    }

    public void testKeyTransDESedeWithDigest() throws Exception {
        this.tryKeyTransWithDigest(CMSAlgorithm.DES_EDE3_CBC);
    }

    public void testOriginatorInfo() throws Exception {
        ASN1ObjectIdentifier macAlg = CMSAlgorithm.DES_EDE3_CBC;
        byte[] data = "Eric H. Echidna".getBytes();
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        X509CertificateHolder origCert = new X509CertificateHolder(_origCert.getEncoded());
        adGen.setOriginatorInfo(new OriginatorInfoGenerator(origCert).generate());
        adGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open(bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build());
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray());
        NewAuthenticatedDataStreamTest.assertTrue((boolean)ad.getOriginatorInfo().getCertificates().getMatches(null).contains(origCert));
        RecipientInformationStore recipients = ad.getRecipientInfos();
        NewAuthenticatedDataStreamTest.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        NewAuthenticatedDataStreamTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewAuthenticatedDataStreamTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(data, recData));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
        }
    }

    private void tryKeyTrans(ASN1ObjectIdentifier macAlg) throws Exception {
        byte[] data = "Eric H. Echidna".getBytes();
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        adGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open(bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build());
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray());
        RecipientInformationStore recipients = ad.getRecipientInfos();
        NewAuthenticatedDataStreamTest.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        NewAuthenticatedDataStreamTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewAuthenticatedDataStreamTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(data, recData));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
        }
    }

    private void tryKeyTransWithDigest(ASN1ObjectIdentifier macAlg) throws Exception {
        byte[] data = "Eric H. Echidna".getBytes();
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DigestCalculatorProvider calcProvider = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        adGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open(bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build(), calcProvider.get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1)));
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray(), calcProvider);
        RecipientInformationStore recipients = ad.getRecipientInfos();
        NewAuthenticatedDataStreamTest.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        NewAuthenticatedDataStreamTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewAuthenticatedDataStreamTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(data, recData));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
            NewAuthenticatedDataStreamTest.assertTrue((boolean)Arrays.equals(ad.getContentDigest(), recipient.getContentDigest()));
        }
    }

    static {
        _initialised = false;
    }
}

