/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.agreement.DHStandardGroups;
import cfca.sadk.org.bouncycastle.crypto.engines.CramerShoupCiphertext;
import cfca.sadk.org.bouncycastle.crypto.engines.CramerShoupCoreEngine;
import cfca.sadk.org.bouncycastle.crypto.generators.CramerShoupKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.generators.CramerShoupParametersGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.CramerShoupKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.CramerShoupParameters;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CramerShoupTest
extends SimpleTest {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom RND = new SecureRandom();
    private AsymmetricCipherKeyPair keyPair;

    public static void main(String[] args) {
        CramerShoupTest.runTest(new CramerShoupTest());
    }

    public String getName() {
        return "CramerShoup";
    }

    public void performTest() throws Exception {
        BigInteger pSubOne = DHStandardGroups.rfc3526_2048.getP().subtract(ONE);
        for (int i = 0; i < 10; ++i) {
            BigInteger message = BigIntegers.createRandomInRange(ONE, pSubOne, RND);
            BigInteger m1 = this.encDecTest(message);
            BigInteger m2 = this.labelledEncDecTest(message, "myRandomLabel");
            BigInteger m3 = this.encDecEncodingTest(message);
            BigInteger m4 = this.labelledEncDecEncodingTest(message, "myOtherCoolLabel");
            if (message.equals(m1) && message.equals(m2) && message.equals(m3) && message.equals(m4)) continue;
            this.fail("decrypted message != original message");
        }
    }

    private BigInteger encDecEncodingTest(BigInteger m) {
        CramerShoupCiphertext ciphertext = this.encrypt(m);
        byte[] c = ciphertext.toByteArray();
        CramerShoupCiphertext decC = new CramerShoupCiphertext(c);
        return this.decrypt(decC);
    }

    private BigInteger labelledEncDecEncodingTest(BigInteger m, String l) {
        byte[] c = this.encrypt(m, l).toByteArray();
        return this.decrypt(new CramerShoupCiphertext(c), l);
    }

    private BigInteger encDecTest(BigInteger m) {
        CramerShoupCiphertext c = this.encrypt(m);
        return this.decrypt(c);
    }

    private BigInteger labelledEncDecTest(BigInteger m, String l) {
        CramerShoupCiphertext c = this.encrypt(m, l);
        return this.decrypt(c, l);
    }

    private BigInteger decrypt(CramerShoupCiphertext ciphertext) {
        return this.decrypt(ciphertext, null);
    }

    private BigInteger decrypt(CramerShoupCiphertext ciphertext, String label) {
        CramerShoupCoreEngine engine = new CramerShoupCoreEngine();
        if (label != null) {
            engine.init(false, this.keyPair.getPrivate(), label);
        } else {
            engine.init(false, this.keyPair.getPrivate());
        }
        try {
            BigInteger m = engine.decryptBlock(ciphertext);
            return m;
        }
        catch (CramerShoupCoreEngine.CramerShoupCiphertextException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CramerShoupCiphertext encrypt(BigInteger message) {
        return this.encrypt(message, null);
    }

    private CramerShoupCiphertext encrypt(BigInteger message, String label) {
        CramerShoupKeyPairGenerator kpGen = new CramerShoupKeyPairGenerator();
        CramerShoupParametersGenerator pGen = new CramerShoupParametersGenerator();
        pGen.init(2048, 1, RND);
        CramerShoupParameters params = pGen.generateParameters(DHStandardGroups.rfc3526_2048);
        CramerShoupKeyGenerationParameters param = new CramerShoupKeyGenerationParameters(RND, params);
        kpGen.init(param);
        this.keyPair = kpGen.generateKeyPair();
        CramerShoupCoreEngine engine = new CramerShoupCoreEngine();
        if (label != null) {
            engine.init(true, this.keyPair.getPublic(), label);
        } else {
            engine.init(true, this.keyPair.getPublic());
        }
        CramerShoupCiphertext ciphertext = engine.encryptBlock(message);
        return ciphertext;
    }
}

