/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import cfca.sadk.org.bouncycastle.crypto.kems.ECIESKeyEncapsulation;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;

public class ECIESKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "ECIESKeyEncapsulation";
    }

    public void performTest() throws Exception {
        X9ECParameters spec = SECNamedCurves.getByName("secp224r1");
        ECDomainParameters ecDomain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
        ECKeyPairGenerator ecGen = new ECKeyPairGenerator();
        ecGen.init(new ECKeyGenerationParameters(ecDomain, new SecureRandom()));
        AsymmetricCipherKeyPair keys = ecGen.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        byte[] out = new byte[57];
        ECIESKeyEncapsulation kem = new ECIESKeyEncapsulation(kdf, rnd);
        kem.init(keys.getPublic());
        KeyParameter key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        KeyParameter key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed basic test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, true, false, false);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed cofactor test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, false, true, false);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed old cofactor test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, false, false, true);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed single hash test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, true, false, true);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed cofactor and single hash test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, false, true, true);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed old cofactor and single hash test");
        }
    }

    public static void main(String[] args) {
        ECIESKeyEncapsulationTest.runTest(new ECIESKeyEncapsulationTest());
    }
}

