/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.dvcs;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import cfca.sadk.org.bouncycastle.asn1.dvcs.Data;
import cfca.sadk.org.bouncycastle.asn1.x509.ExtensionsGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralNames;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataGenerator;
import cfca.sadk.org.bouncycastle.dvcs.DVCSException;
import cfca.sadk.org.bouncycastle.dvcs.DVCSRequest;
import java.io.IOException;
import java.math.BigInteger;

public abstract class DVCSRequestBuilder {
    private final ExtensionsGenerator extGenerator = new ExtensionsGenerator();
    private final CMSSignedDataGenerator signedDataGen = new CMSSignedDataGenerator();
    protected final DVCSRequestInformationBuilder requestInformationBuilder;

    protected DVCSRequestBuilder(DVCSRequestInformationBuilder requestInformationBuilder) {
        this.requestInformationBuilder = requestInformationBuilder;
    }

    public void setNonce(BigInteger nonce) {
        this.requestInformationBuilder.setNonce(nonce);
    }

    public void setRequester(GeneralName requester) {
        this.requestInformationBuilder.setRequester(requester);
    }

    public void setDVCS(GeneralName dvcs) {
        this.requestInformationBuilder.setDVCS(dvcs);
    }

    public void setDVCS(GeneralNames dvcs) {
        this.requestInformationBuilder.setDVCS(dvcs);
    }

    public void setDataLocations(GeneralName dataLocation) {
        this.requestInformationBuilder.setDataLocations(dataLocation);
    }

    public void setDataLocations(GeneralNames dataLocations) {
        this.requestInformationBuilder.setDataLocations(dataLocations);
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws DVCSException {
        try {
            this.extGenerator.addExtension(oid, isCritical, value);
        }
        catch (IOException e) {
            throw new DVCSException("cannot encode extension: " + e.getMessage(), e);
        }
    }

    protected DVCSRequest createDVCRequest(Data data) throws DVCSException {
        if (!this.extGenerator.isEmpty()) {
            this.requestInformationBuilder.setExtensions(this.extGenerator.generate());
        }
        cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSRequest request = new cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSRequest(this.requestInformationBuilder.build(), data);
        return new DVCSRequest(new ContentInfo(DVCSObjectIdentifiers.id_ct_DVCSRequestData, request));
    }
}

